/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Acceptor;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.processor.Router;
import org.mule.runtime.core.api.routing.MessageSequence;
import org.mule.runtime.core.api.util.collection.SplittingStrategy;
import org.mule.runtime.core.expression.ExpressionConfig;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.internal.routing.EventToMessageSequenceSplittingStrategy;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.AbstractMessageSequenceSplitter;

public class Splitter
extends AbstractMessageSequenceSplitter
implements Initialisable,
Router {
    private ExpressionConfig config = new ExpressionConfig("#[payload]");
    private SplittingStrategy<Event, MessageSequence<?>> strategy;
    private String filterOnErrorType = null;

    public Splitter() {
    }

    public Splitter(ExpressionConfig config, String filterOnErrorType) {
        this.config = config;
        this.filterOnErrorType = filterOnErrorType;
    }

    @Override
    protected MessageSequence<?> splitMessageIntoSequence(Event event) {
        return this.strategy.split(event);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.config.validate();
        this.strategy = new EventToMessageSequenceSplittingStrategy(new ExpressionSplittingStrategy(this.muleContext.getExpressionManager(), this.config.getFullExpression()));
        this.filterOnErrorTypeAcceptor = this.createFilterOnErrorTypeAcceptor(TemplateOnErrorHandler.createErrorType(this.muleContext.getErrorTypeRepository(), this.filterOnErrorType));
    }

    private Acceptor createFilterOnErrorTypeAcceptor(final ErrorTypeMatcher filterOnErrorTypeMatcher) {
        return new Acceptor(){

            @Override
            public boolean acceptsAll() {
                return false;
            }

            @Override
            public boolean accept(Event event) {
                return filterOnErrorTypeMatcher != null && filterOnErrorTypeMatcher.match(event.getError().get().getErrorType());
            }
        };
    }

    public void setExpression(String expression) {
        this.config.setExpression(expression);
    }

    public void setFilterOnErrorType(String filterOnErrorType) {
        this.filterOnErrorType = filterOnErrorType;
    }
}

