/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Acceptor;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.message.GroupCorrelation;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.routing.MessageSequence;
import org.mule.runtime.core.api.routing.RouterResultsHandler;
import org.mule.runtime.core.internal.routing.outbound.PartitionedMessageSequence;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.mule.runtime.core.privileged.routing.DefaultRouterResultsHandler;
import org.mule.runtime.core.routing.outbound.EventBuilderConfigurer;

public abstract class AbstractMessageSequenceSplitter
extends AbstractInterceptingMessageProcessor
implements MuleContextAware {
    protected RouterResultsHandler resultsHandler = new DefaultRouterResultsHandler();
    protected int batchSize;
    protected String counterVariableName;
    protected Acceptor filterOnErrorTypeAcceptor = new Acceptor(){

        @Override
        public boolean acceptsAll() {
            return false;
        }

        @Override
        public boolean accept(Event event) {
            return false;
        }
    };

    @Override
    public final Event process(Event event) throws MuleException {
        if (this.isSplitRequired(event)) {
            MessageSequence<?> seq = this.splitMessageIntoSequence(event);
            if (!seq.isEmpty()) {
                return this.resultsHandler.aggregateResults(this.processParts(seq, event), event);
            }
            this.logger.warn("Splitter returned no results. If this is not expected, please check your split expression");
            return event;
        }
        return this.processNext(event);
    }

    protected boolean isSplitRequired(Event event) {
        return true;
    }

    protected abstract MessageSequence<?> splitMessageIntoSequence(Event var1) throws MuleException;

    protected List<Event> processParts(MessageSequence<?> seq, Event originalEvent) throws MuleException {
        ArrayList<Event> resultEvents = new ArrayList<Event>();
        int correlationSequence = 0;
        MessageSequence<?> messageSequence = seq;
        if (this.batchSize > 1) {
            messageSequence = new PartitionedMessageSequence(seq, this.batchSize);
        }
        Integer count = messageSequence.size();
        Event lastResult = null;
        while (messageSequence.hasNext()) {
            ++correlationSequence;
            Event.Builder builder = Event.builder(originalEvent);
            this.propagateFlowVars(lastResult, builder);
            if (this.counterVariableName != null) {
                builder.addVariable(this.counterVariableName, correlationSequence);
            }
            builder.groupCorrelation(new GroupCorrelation(count, correlationSequence));
            this.initEventBuilder(messageSequence.next(), originalEvent, builder, this.resolvePropagatedFlowVars(lastResult));
            try {
                Event resultEvent = MessageProcessors.processToApplyWithChildContext(builder.build(), this.applyNext());
                if (resultEvent == null) continue;
                resultEvents.add(Event.builder(originalEvent.getContext(), resultEvent).build());
                lastResult = resultEvent;
            }
            catch (MessagingException e) {
                if (this.filterOnErrorTypeAcceptor.accept(e.getEvent())) continue;
                throw e;
            }
        }
        if (correlationSequence == 1) {
            this.logger.debug("Splitter only returned a single result. If this is not expected, please check your split expression");
        }
        return resultEvents;
    }

    protected Set<String> resolvePropagatedFlowVars(Event lastResult) {
        return Collections.emptySet();
    }

    protected void propagateFlowVars(Event previousResult, Event.Builder builder) {
    }

    private void initEventBuilder(Object sequenceValue, Event originalEvent, Event.Builder builder, Set<String> flowVarsFromLastResult) {
        if (sequenceValue instanceof EventBuilderConfigurer) {
            ((EventBuilderConfigurer)sequenceValue).configure(builder);
        } else if (sequenceValue instanceof Event) {
            Event payloadAsEvent = (Event)sequenceValue;
            builder.message(payloadAsEvent.getMessage());
            for (String flowVarName : payloadAsEvent.getVariableNames()) {
                if (flowVarsFromLastResult.contains(flowVarName)) continue;
                builder.addVariable(flowVarName, payloadAsEvent.getVariable(flowVarName).getValue(), payloadAsEvent.getVariable(flowVarName).getDataType());
            }
        } else if (sequenceValue instanceof Message) {
            Message message = (Message)sequenceValue;
            builder.message(message);
        } else if (sequenceValue instanceof TypedValue) {
            builder.message(Message.builder().payload(((TypedValue)sequenceValue).getValue()).mediaType(((TypedValue)sequenceValue).getDataType().getMediaType()).build());
        } else if (sequenceValue instanceof Collection) {
            builder.message(Message.builder(originalEvent.getMessage()).payload(((Collection)sequenceValue).stream().map(v -> v instanceof TypedValue ? ((TypedValue)v).getValue() : v).collect(Collectors.toList())).build());
        } else {
            builder.message(Message.builder(originalEvent.getMessage()).payload(sequenceValue).build());
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }
}

