/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.core.transformer.simple.SerializableToByteArray;

public class ObjectToByteArray
extends SerializableToByteArray {
    public ObjectToByteArray() {
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.STRING);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
        this.registerSourceType(DataType.fromType(OutputHandler.class));
        this.registerSourceType(DataType.fromType(Byte.class));
        this.registerSourceType(DataType.fromType(Byte.TYPE));
        this.setReturnDataType(DataType.BYTE_ARRAY);
    }

    @Override
    public Object doTransform(Object src, Charset outputEncoding) throws TransformerException {
        try {
            if (src instanceof String) {
                return src.toString().getBytes(outputEncoding);
            }
            if (src instanceof CursorStreamProvider) {
                return this.transformStream((InputStream)((CursorStreamProvider)src).openCursor());
            }
            if (src instanceof InputStream) {
                return this.transformStream((InputStream)src);
            }
            if (src instanceof OutputHandler) {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                try {
                    ((OutputHandler)src).write(Event.getCurrentEvent(), bytes);
                    return bytes.toByteArray();
                }
                catch (IOException e) {
                    throw new TransformerException(this, (Throwable)e);
                }
            }
            if (src instanceof Byte) {
                return new byte[]{(Byte)src};
            }
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
        return super.doTransform(src, outputEncoding);
    }

    private Object transformStream(InputStream is) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try {
            IOUtils.copyLarge(is, byteOut);
        }
        finally {
            is.close();
        }
        return byteOut.toByteArray();
    }
}

