/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.store;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.store.ListableObjectStore;
import org.mule.runtime.core.api.store.PartitionableExpirableObjectStore;
import org.mule.runtime.core.api.store.PartitionableObjectStore;
import org.mule.runtime.core.internal.util.store.MonitoredObjectStoreWrapper;
import org.mule.runtime.core.internal.util.store.ObjectStorePartition;
import org.mule.runtime.core.internal.util.store.PartitionedObjectStoreWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuleObjectStoreManager
implements ObjectStoreManager,
MuleContextAware,
Initialisable,
Disposable {
    private static Logger logger = LoggerFactory.getLogger(MuleObjectStoreManager.class);
    protected Scheduler scheduler;
    MuleContext muleContext;
    protected ConcurrentMap<String, ObjectStore<?>> stores = new ConcurrentHashMap();
    private final ConcurrentMap<String, ScheduledFuture<?>> monitors = new ConcurrentHashMap();
    private String baseTransientStoreKey = "_defaultInMemoryObjectStore";
    private String basePersistentStoreKey = "_defaultPersistentObjectStore";
    private String baseTransientUserStoreKey = "_defaultTransientUserObjectStore";
    private String basePersistentUserStoreKey = "_defaultUserObjectStore";

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name) {
        return this.getObjectStore(name, false);
    }

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name, boolean isPersistent) {
        return this.internalCreateStore((ListableObjectStore<? extends Serializable>)this.getBaseStore(isPersistent), name, 0, 0L, 0L);
    }

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getObjectStore(String name, boolean isPersistent, int maxEntries, long entryTTL, long expirationInterval) {
        return this.internalCreateStore((ListableObjectStore<? extends Serializable>)this.getBaseStore(isPersistent), name, maxEntries, entryTTL, expirationInterval);
    }

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getUserObjectStore(String name, boolean isPersistent) {
        return this.internalCreateStore((ListableObjectStore<? extends Serializable>)this.getBaseUserStore(isPersistent), name, 0, 0L, 0L);
    }

    @Override
    public <T extends ObjectStore<? extends Serializable>> T getUserObjectStore(String name, boolean isPersistent, int maxEntries, long entryTTL, long expirationInterval) {
        return this.internalCreateStore((ListableObjectStore<? extends Serializable>)this.getBaseUserStore(isPersistent), name, maxEntries, entryTTL, expirationInterval);
    }

    public synchronized <T extends ObjectStore<? extends Serializable>> T internalCreateStore(ListableObjectStore<? extends Serializable> baseStore, String name, int maxEntries, long entryTTL, long expirationInterval) {
        if (maxEntries < 0) {
            maxEntries = 0;
        }
        if (entryTTL < 0L) {
            entryTTL = 0L;
        }
        if (this.stores.containsKey(name)) {
            return (T)((ObjectStore)this.stores.get(name));
        }
        T store = null;
        try {
            store = this.getPartitionFromBaseObjectStore(baseStore, name);
        }
        catch (ObjectStoreException e) {
            throw new MuleRuntimeException(e);
        }
        if (maxEntries == 0 && entryTTL == 0L) {
            return this.putInStoreMap(name, store);
        }
        return this.getMonitorablePartition(name, baseStore, store, entryTTL, maxEntries, expirationInterval);
    }

    private <T extends ListableObjectStore<? extends Serializable>> T getBaseUserStore(boolean persistent) {
        ListableObjectStore baseStore = persistent ? (ListableObjectStore)this.muleContext.getRegistry().lookupObject(this.basePersistentUserStoreKey) : (ListableObjectStore)this.muleContext.getRegistry().lookupObject(this.baseTransientUserStoreKey);
        return (T)baseStore;
    }

    private <T extends ListableObjectStore<? extends Serializable>> T getBaseStore(boolean persistent) {
        ListableObjectStore baseStore = persistent ? (ListableObjectStore)this.muleContext.getRegistry().lookupObject(this.basePersistentStoreKey) : (ListableObjectStore)this.muleContext.getRegistry().lookupObject(this.baseTransientStoreKey);
        return (T)baseStore;
    }

    private <T extends ObjectStore<? extends Serializable>> T getPartitionFromBaseObjectStore(ListableObjectStore<? extends Serializable> baseStore, String partitionName) throws ObjectStoreException {
        if (baseStore instanceof PartitionableObjectStore) {
            ObjectStorePartition objectStorePartition = new ObjectStorePartition(partitionName, (PartitionableObjectStore)baseStore);
            objectStorePartition.open();
            return (T)objectStorePartition;
        }
        PartitionedObjectStoreWrapper<? extends Serializable> partitionedObjectStoreWrapper = new PartitionedObjectStoreWrapper<Serializable>(partitionName, this.muleContext, baseStore);
        partitionedObjectStoreWrapper.open();
        return (T)partitionedObjectStoreWrapper;
    }

    private <T extends ObjectStore<? extends Serializable>> T putInStoreMap(String name, T store) {
        ObjectStore<?> previous = this.stores.putIfAbsent(name, store);
        if (previous == null) {
            return store;
        }
        return (T)previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ObjectStore<? extends Serializable>> T getMonitorablePartition(String name, ListableObjectStore baseStore, T store, long entryTTL, int maxEntries, long expirationInterval) {
        MonitoredObjectStoreWrapper monObjectStore;
        if (baseStore instanceof PartitionableExpirableObjectStore) {
            ObjectStore<?> previous = this.stores.putIfAbsent(name, store);
            if (previous == null) {
                ScheduledFuture<?> future = this.scheduler.scheduleWithFixedDelay(new Monitor(name, (PartitionableExpirableObjectStore)baseStore, entryTTL, maxEntries), 0L, expirationInterval, TimeUnit.MILLISECONDS);
                this.monitors.put(name, future);
                return store;
            }
            return (T)previous;
        }
        MuleObjectStoreManager muleObjectStoreManager = this;
        synchronized (muleObjectStoreManager) {
            if (this.stores.containsKey(name)) {
                return (T)((ObjectStore)this.stores.get(name));
            }
            monObjectStore = new MonitoredObjectStoreWrapper((ListableObjectStore)store, maxEntries, entryTTL, expirationInterval);
            monObjectStore.setMuleContext(this.muleContext);
            try {
                monObjectStore.initialise();
            }
            catch (InitialisationException e) {
                throw new MuleRuntimeException(e);
            }
            this.stores.put(name, monObjectStore);
        }
        return (T)monObjectStore;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void clearStoreCache() {
        this.stores.clear();
    }

    @Override
    public void dispose() {
        this.scheduler.stop();
        for (ObjectStore objectStore : this.stores.values()) {
            if (!(objectStore instanceof Disposable)) continue;
            ((Disposable)((Object)objectStore)).dispose();
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        this.scheduler = this.muleContext.getSchedulerService().customScheduler(this.muleContext.getSchedulerBaseConfig().withName("ObjectStoreManager-Monitor").withMaxConcurrentTasks(1));
    }

    @Override
    public void disposeStore(ObjectStore<? extends Serializable> store) throws ObjectStoreException {
        if (store instanceof ObjectStorePartition) {
            ObjectStorePartition partition = (ObjectStorePartition)store;
            String partitionName = partition.getPartitionName();
            partition.getBaseStore().disposePartition(partitionName);
            ScheduledFuture future = (ScheduledFuture)this.monitors.remove(partitionName);
            if (future != null) {
                future.cancel(false);
            }
            this.stores.remove(partitionName);
        } else {
            try {
                store.clear();
            }
            catch (UnsupportedOperationException e) {
                logger.warn(String.format("ObjectStore of class %s does not support clearing", store.getClass().getCanonicalName()), (Throwable)e);
            }
            try {
                this.stores.values().remove(store);
            }
            catch (Exception e) {
                logger.warn("Can not remove object store" + store.toString(), (Throwable)e);
            }
        }
        if (store instanceof Disposable) {
            ((Disposable)((Object)store)).dispose();
        }
    }

    int getMonitorsCount() {
        return this.monitors.size();
    }

    public void setBasePersistentStoreKey(String basePersistentStoreKey) {
        this.basePersistentStoreKey = basePersistentStoreKey;
    }

    public void setBaseTransientStoreKey(String baseTransientStoreKey) {
        this.baseTransientStoreKey = baseTransientStoreKey;
    }

    public void setBasePersistentUserStoreKey(String basePersistentUserStoreKey) {
        this.basePersistentUserStoreKey = basePersistentUserStoreKey;
    }

    public void setBaseTransientUserStoreKey(String baseTransientUserStoreKey) {
        this.baseTransientUserStoreKey = baseTransientUserStoreKey;
    }

    class Monitor
    implements Runnable {
        private final String partitionName;
        private final PartitionableExpirableObjectStore<? extends Serializable> store;
        private final long entryTTL;
        private final int maxEntries;

        public Monitor(String partitionName, PartitionableExpirableObjectStore<? extends Serializable> store, long entryTTL, int maxEntries) {
            this.partitionName = partitionName;
            this.store = store;
            this.entryTTL = entryTTL;
            this.maxEntries = maxEntries;
        }

        @Override
        public void run() {
            if (MuleObjectStoreManager.this.muleContext.isPrimaryPollingInstance()) {
                try {
                    this.store.expire(this.entryTTL, this.maxEntries, this.partitionName);
                }
                catch (Exception e) {
                    logger.warn("Running expirty on partition " + this.partitionName + " of " + this.store + " threw " + e + ":" + e.getMessage());
                }
            }
        }
    }
}

