/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public abstract class AbstractFilteringMessageProcessor
extends AbstractInterceptingMessageProcessor {
    protected boolean throwOnUnaccepted = false;
    protected boolean onUnacceptedFlowConstruct;
    protected Processor unacceptedMessageProcessor;

    @Override
    public Event process(Event event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.unacceptedMessageProcessor == null) {
            return Flux.from(publisher).handle((event, sink) -> {
                boolean accepted;
                Event.Builder builder = Event.builder(event);
                try {
                    accepted = this.accept((Event)event, builder);
                }
                catch (Exception ex) {
                    sink.error((Throwable)this.filterFailureException(builder.build(), ex));
                    return;
                }
                if (accepted) {
                    sink.next((Object)builder.build());
                } else if (this.isThrowOnUnaccepted()) {
                    sink.error((Throwable)this.filterUnacceptedException(builder.build()));
                } else {
                    event.getContext().success();
                }
            }).transform((Function)this.applyNext());
        }
        return Flux.from(publisher).concatMap(event -> {
            Event.Builder builder = Event.builder(event);
            try {
                if (this.accept((Event)event, builder)) {
                    return Flux.just((Object)event).transform((Function)this.applyNext());
                }
                return Flux.just((Object)event).transform((Function)this.unacceptedMessageProcessor);
            }
            catch (Exception ex) {
                return Flux.error((Throwable)this.filterFailureException(builder.build(), ex));
            }
        });
    }

    protected abstract boolean accept(Event var1, Event.Builder var2);

    protected MessagingException filterFailureException(Event event, Exception ex) {
        return new MessagingException(event, ex, (Processor)this);
    }

    protected abstract MuleException filterUnacceptedException(Event var1);

    public void setUnacceptedMessageProcessor(Processor unacceptedMessageProcessor) {
        this.unacceptedMessageProcessor = unacceptedMessageProcessor;
        if (unacceptedMessageProcessor instanceof FlowConstruct) {
            this.onUnacceptedFlowConstruct = true;
        }
    }

    public boolean isThrowOnUnaccepted() {
        return this.throwOnUnaccepted;
    }

    public void setThrowOnUnaccepted(boolean throwOnUnaccepted) {
        this.throwOnUnaccepted = throwOnUnaccepted;
    }
}

