/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.security.SecurityFilter;
import org.mule.runtime.core.privileged.processor.AbstractInterceptingMessageProcessor;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

public class SecurityFilterMessageProcessor
extends AbstractInterceptingMessageProcessor
implements Initialisable {
    private SecurityFilter filter;

    @Deprecated
    public SecurityFilterMessageProcessor() {
    }

    @Override
    public void initialise() throws InitialisationException {
        try {
            if (this.filter != null) {
                this.muleContext.getInjector().inject(this.filter);
                LifecycleUtils.initialiseIfNeeded(this.filter, this.muleContext);
            }
        }
        catch (MuleException e) {
            throw new InitialisationException((Throwable)e, (Initialisable)this);
        }
    }

    public SecurityFilterMessageProcessor(SecurityFilter filter) {
        this.filter = filter;
    }

    public SecurityFilter getFilter() {
        return this.filter;
    }

    @Override
    public Event process(Event event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        if (this.filter == null) {
            return Flux.from(publisher).transform((Function)this.applyNext());
        }
        return Flux.from(publisher).doOnNext(event -> {
            try {
                this.filter.doFilter((Event)event);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }).transform((Function)this.applyNext());
    }

    public void setFilter(SecurityFilter filter) {
        this.filter = filter;
    }
}

