/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.simple;

import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.util.AttributeEvaluator;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.api.util.WildcardAttributeEvaluator;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoveVariablePropertyProcessor
extends SimpleMessageProcessor {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRemoveVariablePropertyProcessor.class);
    private AttributeEvaluator identifierEvaluator;
    private WildcardAttributeEvaluator wildcardAttributeEvaluator;

    @Override
    public void initialise() throws InitialisationException {
        this.identifierEvaluator.initialize(this.muleContext.getExpressionManager());
    }

    @Override
    public Event process(Event event) throws MuleException {
        if (this.wildcardAttributeEvaluator.hasWildcards()) {
            AtomicReference<Event> resultEvent = new AtomicReference<Event>(event);
            this.wildcardAttributeEvaluator.processValues(this.getPropertyNames(event), matchedValue -> {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Removing property: '%s' from scope: '%s'", matchedValue, this.getScopeName()));
                }
                resultEvent.set(this.removeProperty(event, matchedValue));
            });
            return resultEvent.get();
        }
        String key = (String)this.identifierEvaluator.resolveValue(event);
        if (key != null) {
            return this.removeProperty(event, key);
        }
        logger.info("Key expression return null, no property will be removed");
        return event;
    }

    protected abstract Set<String> getPropertyNames(Event var1);

    protected abstract Event removeProperty(Event var1, String var2);

    public Object clone() throws CloneNotSupportedException {
        AbstractRemoveVariablePropertyProcessor clone = (AbstractRemoveVariablePropertyProcessor)super.clone();
        clone.setIdentifier(this.identifierEvaluator.getRawValue());
        return clone;
    }

    public void setIdentifier(String identifier) {
        if (StringUtils.isBlank(identifier)) {
            throw new IllegalArgumentException("Remove with null identifier is not supported");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier, DataType.STRING);
        this.wildcardAttributeEvaluator = new WildcardAttributeEvaluator(identifier);
    }

    protected abstract String getScopeName();
}

