/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.security.filters;

import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.security.CredentialsNotSetException;
import org.mule.runtime.core.api.security.CryptoFailureException;
import org.mule.runtime.core.api.security.DefaultMuleAuthentication;
import org.mule.runtime.core.api.security.DefaultMuleCredentials;
import org.mule.runtime.core.api.security.EncryptionStrategy;
import org.mule.runtime.core.api.security.EncryptionStrategyNotFoundException;
import org.mule.runtime.core.api.security.SecurityContext;
import org.mule.runtime.core.api.security.UnauthorisedException;
import org.mule.runtime.core.security.AbstractOperationSecurityFilter;
import org.mule.runtime.core.security.MuleHeaderCredentialsAccessor;

public class MuleEncryptionEndpointSecurityFilter
extends AbstractOperationSecurityFilter {
    private EncryptionStrategy strategy;

    public MuleEncryptionEndpointSecurityFilter(EncryptionStrategy strategy) {
        this.strategy = strategy;
        this.setCredentialsAccessor(new MuleHeaderCredentialsAccessor());
    }

    @Override
    protected Event authenticateInbound(Event event) throws SecurityException, SecurityProviderNotFoundException, CryptoFailureException, EncryptionStrategyNotFoundException, UnknownAuthenticationTypeException {
        Authentication authentication;
        String userHeader = (String)((Object)this.getCredentialsAccessor().getCredentials(event));
        if (userHeader == null) {
            throw new CredentialsNotSetException(event, event.getSession().getSecurityContext(), this);
        }
        DefaultMuleCredentials user = new DefaultMuleCredentials(userHeader, this.getSecurityManager());
        try {
            authentication = this.getSecurityManager().authenticate(new DefaultMuleAuthentication(user));
        }
        catch (Exception e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Authentication request for user: " + user.getUsername() + " failed: " + e.toString());
            }
            throw new UnauthorisedException(CoreMessages.authFailedForUser(user.getUsername()), (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Authentication success: " + authentication.toString());
        }
        SecurityContext context = this.getSecurityManager().createSecurityContext(authentication);
        context.setAuthentication(authentication);
        event.getSession().setSecurityContext(context);
        return event;
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        if (this.strategy == null) {
            throw new InitialisationException(CoreMessages.encryptionStrategyNotSet(), (Initialisable)this);
        }
    }
}

