/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.ExternalLibraryModel;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.SubTypesModel;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.AbstractComplexModel;

public class ImmutableExtensionModel
extends AbstractComplexModel
implements ExtensionModel {
    private final String vendor;
    private final String version;
    private final MuleVersion minMuleVersion;
    private final Category category;
    private final List<ConfigurationModel> configurations;
    private final Set<String> privilegedPackages;
    private final Set<String> privilegedArtifacts;
    private final Set<ErrorModel> errors;
    private final Set<ObjectType> types;
    private final Set<String> resources;
    private final XmlDslModel xmlDslModel;
    private final Set<SubTypesModel> subTypes;
    private final Set<ImportedTypeModel> importedTypes;
    private final Set<ExternalLibraryModel> externalLibraries;

    public ImmutableExtensionModel(String name, String description, String version, String vendor, Category category, MuleVersion minMuleVersion, List<ConfigurationModel> configurationModels, List<OperationModel> operationModels, List<ConnectionProviderModel> connectionProviders, List<SourceModel> sourceModels, List<FunctionModel> functions, DisplayModel displayModel, XmlDslModel xmlDslModel, Set<SubTypesModel> subTypes, Set<ObjectType> types, Set<String> resources, Set<ImportedTypeModel> importedTypes, Set<ErrorModel> errors, Set<ExternalLibraryModel> externalLibraryModels, Set<ModelProperty> modelProperties, Set<String> privilegedPackages, Set<String> privilegedArtifacts) {
        super(name, description, operationModels, connectionProviders, sourceModels, displayModel, modelProperties, functions);
        this.configurations = this.unique(configurationModels, "Configurations");
        this.checkModelArgument(version != null && version.length() > 0, "Version cannot be blank");
        this.checkModelArgument(minMuleVersion != null, "Extension Minimum Mule Version cannot be null");
        this.checkModelArgument(category != null, "Extension Category cannot be null");
        this.checkModelArgument(vendor != null, "Extension Vendor cannot be null");
        this.checkModelArgument(xmlDslModel != null, "xmlDslModel cannot be null");
        this.minMuleVersion = minMuleVersion;
        this.category = category;
        this.version = version;
        this.vendor = vendor;
        this.types = this.copy(types);
        this.resources = this.copy(resources);
        this.importedTypes = this.copy(importedTypes);
        this.subTypes = this.copy(subTypes);
        this.xmlDslModel = xmlDslModel;
        this.errors = errors;
        this.externalLibraries = Collections.unmodifiableSet(externalLibraryModels);
        this.privilegedPackages = privilegedPackages;
        this.privilegedArtifacts = privilegedArtifacts;
    }

    @Override
    public List<ConfigurationModel> getConfigurationModels() {
        return this.configurations;
    }

    @Override
    public Optional<ConfigurationModel> getConfigurationModel(String name) {
        return this.findModel(this.configurations, name);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public MuleVersion getMinMuleVersion() {
        return this.minMuleVersion;
    }

    @Override
    public Set<ObjectType> getTypes() {
        return this.types;
    }

    @Override
    public Set<String> getPrivilegedPackages() {
        return this.privilegedPackages;
    }

    @Override
    public Set<String> getPrivilegedArtifacts() {
        return this.privilegedArtifacts;
    }

    @Override
    public Set<String> getResources() {
        return this.resources;
    }

    @Override
    public Set<ImportedTypeModel> getImportedTypes() {
        return this.importedTypes;
    }

    @Override
    public XmlDslModel getXmlDslModel() {
        return this.xmlDslModel;
    }

    @Override
    public Set<SubTypesModel> getSubTypes() {
        return this.subTypes;
    }

    @Override
    public Set<ErrorModel> getErrorModels() {
        return this.errors;
    }

    @Override
    public Set<ExternalLibraryModel> getExternalLibraryModels() {
        return this.externalLibraries;
    }

    private void checkModelArgument(boolean condition, String errorMessage) {
        if (!condition) {
            throw new IllegalModelDefinitionException(errorMessage);
        }
    }
}

