/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.enricher;

import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.declaration.type.RedeliveryPolicyTypeBuilder;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.util.XmlModelUtils;
import org.mule.runtime.extension.internal.loader.enricher.InfrastructureDeclarationEnricher;
import org.mule.runtime.extension.internal.property.QNameModelProperty;

public final class SourceDeclarationEnricher
extends InfrastructureDeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onSource(SourceDeclaration declaration) {
                SourceDeclarationEnricher.this.addRedeliveryPolicy(declaration);
                SourceDeclarationEnricher.this.addReconnectionStrategyParameter(declaration);
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    protected void addRedeliveryPolicy(ParameterizedDeclaration declaration) {
        ParameterDeclaration parameter = new ParameterDeclaration("redeliveryPolicy");
        parameter.setDescription("Defines a policy for processing the redelivery of the same message");
        parameter.setExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        parameter.setRequired(false);
        parameter.setParameterRole(ParameterRole.BEHAVIOUR);
        parameter.setType(new RedeliveryPolicyTypeBuilder().buildRedeliveryPolicyType(), false);
        parameter.setLayoutModel(LayoutModel.builder().tabName("Redelivery").build());
        parameter.setDslConfiguration(ParameterDslConfiguration.builder().allowsInlineDefinition(true).allowsReferences(false).allowTopLevelDefinition(false).build());
        parameter.addModelProperty(new QNameModelProperty(XmlModelUtils.MULE_ABSTRACT_REDELIVERY_POLICY_QNAME));
        this.markAsInfrastructure(parameter, 1);
        declaration.getParameterGroup("General").addParameter(parameter);
    }
}

