/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.internal.loader.validator;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.function.FunctionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public final class FunctionModelValidator
implements ExtensionModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                if (!model.getFunctionModels().isEmpty()) {
                    problemsReporter.addError(new Problem(model, String.format("Configuration [%s] declares scoped functions, but only extension-level functions are allowed", model.getName())));
                }
            }

            @Override
            protected void onFunction(FunctionModel model) {
                model.getAllParameterModels().forEach(p -> FunctionModelValidator.this.validateParameter(model, p, problemsReporter));
            }
        }.walk(extensionModel);
    }

    private void validateParameter(FunctionModel model, ParameterModel parameter, ProblemsReporter problemsReporter) {
        if (parameter.isOverrideFromConfig()) {
            problemsReporter.addError(new Problem(model, String.format("Parameter [%s] is declared as config override, but functions cannot be bound to a config.", parameter.getName())));
        }
        if (!parameter.getRole().equals((Object)ParameterRole.BEHAVIOUR)) {
            problemsReporter.addError(new Problem(model, String.format("Parameter [%s] is declared as Content, but that is not allowed for functions.", parameter.getName())));
        }
    }
}

