/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeploymentException;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.application.ApplicationDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.application.ApplicationClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptorUtils;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.application.ApplicationWrapper;
import org.mule.runtime.module.deployment.impl.internal.application.DefaultMuleApplication;
import org.mule.runtime.module.deployment.impl.internal.application.MuleApplicationPolicyProvider;
import org.mule.runtime.module.deployment.impl.internal.artifact.ArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainRepository;
import org.mule.runtime.module.deployment.impl.internal.plugin.ArtifactPluginDescriptorLoader;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyInstanceProviderFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.DefaultPolicyTemplateFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.PolicyTemplateClassLoaderBuilderFactory;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderRepository;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.mule.runtime.module.service.ServiceRepository;

public class DefaultApplicationFactory
implements ArtifactFactory<Application> {
    private final ApplicationDescriptorFactory applicationDescriptorFactory;
    private final DomainRepository domainRepository;
    private final ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory;
    private final ServiceRepository serviceRepository;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final ClassLoaderRepository classLoaderRepository;
    private final PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader;

    public DefaultApplicationFactory(ApplicationClassLoaderBuilderFactory applicationClassLoaderBuilderFactory, ApplicationDescriptorFactory applicationDescriptorFactory, DomainRepository domainRepository, ServiceRepository serviceRepository, ExtensionModelLoaderRepository extensionModelLoaderRepository, ClassLoaderRepository classLoaderRepository, PolicyTemplateClassLoaderBuilderFactory policyTemplateClassLoaderBuilderFactory, PluginDependenciesResolver pluginDependenciesResolver, ArtifactPluginDescriptorLoader artifactPluginDescriptorLoader) {
        Preconditions.checkArgument(applicationClassLoaderBuilderFactory != null, "Application classloader builder factory cannot be null");
        Preconditions.checkArgument(applicationDescriptorFactory != null, "Application descriptor factory cannot be null");
        Preconditions.checkArgument(domainRepository != null, "Domain repository cannot be null");
        Preconditions.checkArgument(serviceRepository != null, "Service repository cannot be null");
        Preconditions.checkArgument(extensionModelLoaderRepository != null, "extensionModelLoaderRepository cannot be null");
        Preconditions.checkArgument(classLoaderRepository != null, "classLoaderRepository cannot be null");
        Preconditions.checkArgument(policyTemplateClassLoaderBuilderFactory != null, "policyClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument(pluginDependenciesResolver != null, "pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument(artifactPluginDescriptorLoader != null, "artifactPluginDescriptorLoader cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.applicationClassLoaderBuilderFactory = applicationClassLoaderBuilderFactory;
        this.applicationDescriptorFactory = applicationDescriptorFactory;
        this.domainRepository = domainRepository;
        this.serviceRepository = serviceRepository;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.policyTemplateClassLoaderBuilderFactory = policyTemplateClassLoaderBuilderFactory;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.artifactPluginDescriptorLoader = artifactPluginDescriptorLoader;
    }

    @Override
    public Application createArtifact(File appDir) throws IOException {
        String appName = appDir.getName();
        if (appName.contains(" ")) {
            throw new IllegalArgumentException("Mule application name may not contain spaces: " + appName);
        }
        ApplicationDescriptor descriptor = (ApplicationDescriptor)this.applicationDescriptorFactory.create(appDir);
        return this.createArtifact(descriptor);
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleAppsDir();
    }

    public Application createArtifact(ApplicationDescriptor descriptor) throws IOException {
        Domain domain = this.domainRepository.getDomain(descriptor.getDomain());
        if (domain == null) {
            throw new DeploymentException(I18nMessageFactory.createStaticMessage(String.format("Domain '%s' has to be deployed in order to deploy Application '%s'", descriptor.getDomain(), descriptor.getName())));
        }
        List<ArtifactPluginDescriptor> applicationPluginDescriptors = this.getArtifactPluginDescriptors(((DomainDescriptor)domain.getDescriptor()).getPlugins(), descriptor);
        List<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(applicationPluginDescriptors);
        ApplicationClassLoaderBuilder artifactClassLoaderBuilder = this.applicationClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader applicationClassLoader = ((ApplicationClassLoaderBuilder)((ApplicationClassLoaderBuilder)((ApplicationClassLoaderBuilder)artifactClassLoaderBuilder.setDomain(domain).addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[0]))).setArtifactId(descriptor.getName())).setArtifactDescriptor(descriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(applicationClassLoader, resolvedArtifactPluginDescriptors);
        MuleApplicationPolicyProvider applicationPolicyProvider = new MuleApplicationPolicyProvider(new DefaultPolicyTemplateFactory(this.policyTemplateClassLoaderBuilderFactory, this.pluginDependenciesResolver), new DefaultPolicyInstanceProviderFactory(this.serviceRepository, this.classLoaderRepository, this.extensionModelLoaderRepository));
        DefaultMuleApplication delegate = new DefaultMuleApplication(descriptor, applicationClassLoader, artifactPlugins, this.domainRepository, this.serviceRepository, this.extensionModelLoaderRepository, descriptor.getArtifactLocation(), this.classLoaderRepository, applicationPolicyProvider);
        applicationPolicyProvider.setApplication(delegate);
        return new ApplicationWrapper(delegate);
    }

    private List<ArtifactPluginDescriptor> getArtifactPluginDescriptors(Set<ArtifactPluginDescriptor> domainPlugins, ApplicationDescriptor descriptor) {
        ArrayList<ArtifactPluginDescriptor> artifactPluginDescriptors = new ArrayList<ArtifactPluginDescriptor>();
        for (ArtifactPluginDescriptor appPluginDescriptor : this.getArtifactPluginDescriptors(descriptor)) {
            Optional<ArtifactPluginDescriptor> domainPluginDescriptor = this.findPlugin(domainPlugins, appPluginDescriptor.getBundleDescriptor());
            if (!domainPluginDescriptor.isPresent()) {
                artifactPluginDescriptors.add(appPluginDescriptor);
                continue;
            }
            if (BundleDescriptorUtils.isCompatibleVersion(domainPluginDescriptor.get().getBundleDescriptor().getVersion(), appPluginDescriptor.getBundleDescriptor().getVersion())) continue;
            throw new IllegalStateException(String.format("Incompatible version of plugin '%s' found. Application requires version'%s' but domain provides version'%s'", appPluginDescriptor.getName(), appPluginDescriptor.getBundleDescriptor().getVersion(), domainPluginDescriptor.get().getBundleDescriptor().getVersion()));
        }
        return artifactPluginDescriptors;
    }

    private Set<ArtifactPluginDescriptor> getArtifactPluginDescriptors(ApplicationDescriptor descriptor) {
        if (descriptor.getPlugins().isEmpty()) {
            HashSet<ArtifactPluginDescriptor> pluginDescriptors = new HashSet<ArtifactPluginDescriptor>();
            for (BundleDependency bundleDependency : descriptor.getClassLoaderModel().getDependencies()) {
                if (!bundleDependency.getDescriptor().isPlugin()) continue;
                File pluginZip = new File(bundleDependency.getBundleUri());
                try {
                    pluginDescriptors.add(this.artifactPluginDescriptorLoader.load(pluginZip));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Cannot create plugin descriptor: " + pluginZip.getAbsolutePath(), e);
                }
            }
            return pluginDescriptors;
        }
        return descriptor.getPlugins();
    }

    private Optional<ArtifactPluginDescriptor> findPlugin(Set<ArtifactPluginDescriptor> appPlugins, BundleDescriptor bundleDescriptor) {
        for (ArtifactPluginDescriptor appPlugin : appPlugins) {
            if (!appPlugin.getBundleDescriptor().getArtifactId().equals(bundleDescriptor.getArtifactId()) || !appPlugin.getBundleDescriptor().getGroupId().equals(bundleDescriptor.getGroupId())) continue;
            return Optional.of(appPlugin);
        }
        return Optional.empty();
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader applicationClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(applicationClassLoader.getArtifactId(), artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, applicationClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }
}

