/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.maven;

import com.google.common.io.Files;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.model.Model;
import org.mule.maven.client.api.LocalRepositorySupplierFactory;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.BundleDependency;
import org.mule.maven.client.api.model.BundleDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.MuleFoldersUtil;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.descriptor.BundleDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleScope;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModel;
import org.mule.runtime.module.artifact.descriptor.ClassLoaderModelLoader;
import org.mule.runtime.module.artifact.descriptor.InvalidDescriptorLoaderException;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMavenClassLoaderModelLoader
implements ClassLoaderModelLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LocalRepositorySupplierFactory localRepositorySupplierFactory;
    private MavenClient mavenClient;

    public AbstractMavenClassLoaderModelLoader(MavenClient mavenClient, LocalRepositorySupplierFactory localRepositorySupplierFactory) {
        this.mavenClient = mavenClient;
        this.localRepositorySupplierFactory = localRepositorySupplierFactory;
    }

    @Override
    public String getId() {
        return "maven";
    }

    @Override
    public final ClassLoaderModel load(File artifactFile, Map<String, Object> attributes, ArtifactType artifactType) throws InvalidDescriptorLoaderException {
        return this.createClassLoaderModel(artifactFile, attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoaderModel createClassLoaderModel(File artifactFile, Map<String, Object> attributes) throws InvalidDescriptorLoaderException {
        File containerRepository = null;
        if (!(!MuleContainerBootstrapUtils.isStandalone() || Boolean.getBoolean("mule.mode.embedded") || (containerRepository = new File(MuleFoldersUtil.getMuleHomeFolder(), "repository")).exists() || containerRepository.mkdirs() || containerRepository.exists())) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failure creating repository folder in MULE_HOME folder " + containerRepository.getAbsolutePath()));
        }
        File localMavenRepositoryLocation = this.mavenClient.getMavenConfiguration().getLocalMavenRepositoryLocation();
        Supplier<File> compositeRepoLocationSupplier = this.localRepositorySupplierFactory.composeSuppliers(this.localRepositorySupplierFactory.artifactFolderRepositorySupplier(artifactFile, localMavenRepositoryLocation), this.localRepositorySupplierFactory.fixedFolderSupplier(localMavenRepositoryLocation));
        File mavenRepository = compositeRepoLocationSupplier.get();
        File temporaryDirectory = Files.createTempDir();
        try {
            List<BundleDependency> dependencies = this.mavenClient.resolveArtifactDependencies(artifactFile, this.enabledTestDependencies(), Optional.of(mavenRepository), Optional.of(temporaryDirectory));
            ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder = new ClassLoaderModel.ClassLoaderModelBuilder();
            classLoaderModelBuilder.exportingPackages(new HashSet<String>(this.getAttribute(attributes, "exportedPackages"))).exportingPrivilegedPackages(new HashSet<String>(this.getAttribute(attributes, "privilegedExportedPackages")), new HashSet<String>(this.getAttribute(attributes, "privilegedArtifactIds"))).exportingResources(new HashSet<String>(this.getAttribute(attributes, "exportedResources")));
            Set<org.mule.runtime.module.artifact.descriptor.BundleDependency> bundleDependencies = dependencies.stream().filter(mavenClientDependency -> !mavenClientDependency.getScope().equals((Object)org.mule.maven.client.api.model.BundleScope.PROVIDED)).map(mavenClientDependency -> this.convertBundleDependency((BundleDependency)mavenClientDependency)).collect(Collectors.toSet());
            this.loadUrls(artifactFile, classLoaderModelBuilder, bundleDependencies);
            classLoaderModelBuilder.dependingOn(bundleDependencies);
            ClassLoaderModel classLoaderModel = classLoaderModelBuilder.build();
            return classLoaderModel;
        }
        finally {
            FileUtils.deleteQuietly((File)temporaryDirectory);
        }
    }

    protected org.mule.runtime.module.artifact.descriptor.BundleDependency convertBundleDependency(BundleDependency mavenClientDependency) {
        BundleDependency.Builder builder = new BundleDependency.Builder().setScope(BundleScope.valueOf(mavenClientDependency.getScope().name())).setBundleUri(mavenClientDependency.getBundleUri()).setDescriptor(this.convertBundleDescriptor(mavenClientDependency.getDescriptor()));
        return builder.build();
    }

    private org.mule.runtime.module.artifact.descriptor.BundleDescriptor convertBundleDescriptor(BundleDescriptor descriptor) {
        BundleDescriptor.Builder builder = new BundleDescriptor.Builder().setGroupId(descriptor.getGroupId()).setArtifactId(descriptor.getArtifactId()).setVersion(descriptor.getBaseVersion()).setType(descriptor.getType());
        descriptor.getClassifier().ifPresent(builder::setClassifier);
        return builder.build();
    }

    public final ClassLoaderModel load(File artifactFile) throws InvalidDescriptorLoaderException {
        return this.createClassLoaderModel(artifactFile, Collections.emptyMap());
    }

    protected Model loadPomModel(File artifactFile) {
        return this.mavenClient.getRawPomModel(artifactFile);
    }

    protected void loadUrls(File artifactFile, ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<org.mule.runtime.module.artifact.descriptor.BundleDependency> dependencies) {
        this.addArtifactSpecificClassloaderConfiguration(artifactFile, classLoaderModelBuilder, dependencies);
        this.addDependenciesToClasspathUrls(classLoaderModelBuilder, dependencies);
    }

    private void addDependenciesToClasspathUrls(ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<org.mule.runtime.module.artifact.descriptor.BundleDependency> dependencies) {
        dependencies.stream().filter(dependency -> !"mule-plugin".equals(dependency.getDescriptor().getClassifier().orElse(null))).filter(dependency -> dependency.getBundleUri() != null).forEach(dependency -> {
            try {
                classLoaderModelBuilder.containing(dependency.getBundleUri().toURL());
            }
            catch (MalformedURLException e) {
                throw new MuleRuntimeException(e);
            }
        });
    }

    private List<String> getAttribute(Map<String, Object> attributes, String attribute) {
        ArrayList attributeObject = attributes.getOrDefault(attribute, new ArrayList());
        Preconditions.checkArgument(attributeObject instanceof List, String.format("The '%s' attribute must be of '%s', found '%s'", attribute, List.class.getName(), attributeObject.getClass().getName()));
        return attributeObject;
    }

    protected boolean enabledTestDependencies() {
        return false;
    }

    protected void addArtifactSpecificClassloaderConfiguration(File artifactFile, ClassLoaderModel.ClassLoaderModelBuilder classLoaderModelBuilder, Set<org.mule.runtime.module.artifact.descriptor.BundleDependency> dependencies) {
    }
}

