/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema;

import com.google.common.collect.ImmutableMap;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.collection.Collectors;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;

public final class ExtensionAnnotationProcessor {
    private static final String PARAM = "@param";
    private static final String VALUE = "value";
    private static final char AT_CHAR = '@';
    private static final char NEW_LINE_CHAR = '\n';
    private static final char SPACE_CHAR = ' ';
    private static final char CLOSING_BRACKET_CHAR = '}';
    private static final char OPENING_BRACKET_CHAR = '{';

    public <T> Optional<Class<T>> classFor(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        try {
            return Optional.of(ClassUtils.loadClass(this.getClassName(typeElement, processingEnvironment), typeElement.getClass()));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public String getClassName(TypeElement typeElement, ProcessingEnvironment processingEnvironment) {
        return processingEnvironment.getElementUtils().getBinaryName(typeElement).toString();
    }

    public Set<TypeElement> getTypeElementsAnnotatedWith(Class<? extends Annotation> annotationType, RoundEnvironment roundEnvironment) {
        return ElementFilter.typesIn(roundEnvironment.getElementsAnnotatedWith(annotationType));
    }

    public List<TypeElement> getAnnotationClassesValue(Element element, Class<? extends Annotation> annotation, Class[] valueClasses) {
        List annotationValues = (List)this.getAnnotationValue(element, annotation);
        if (annotation == null) {
            return Collections.emptyList();
        }
        return Stream.of(valueClasses).map(c -> (TypeElement)this.getElementForClass(annotationValues, (Class<?>)c)).collect(Collectors.toImmutableList());
    }

    public <T> T getAnnotationFromType(ProcessingEnvironment processingEnvironment, TypeElement rootElement, Class<? extends Annotation> annotationClass) {
        return (T)this.classFor(rootElement, processingEnvironment).get().getAnnotation(annotationClass);
    }

    public Element getElementForClass(List<AnnotationValue> annotationValues, Class<?> clazz) {
        return annotationValues.stream().map(e -> ((DeclaredType)e.getValue()).asElement()).filter(e -> e.getSimpleName().toString().equals(clazz.getSimpleName())).findFirst().orElse(null);
    }

    public Map<String, VariableElement> getFieldsAnnotatedWith(TypeElement element, Class<? extends Annotation> annotation) {
        if (element == null) {
            return Collections.emptyMap();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TypeElement superClass = this.getSuperclassElement(element);
        builder.putAll(this.getFieldsAnnotatedWith(superClass, annotation));
        builder.putAll(this.collectAnnotatedElements(ElementFilter.fieldsIn(element.getEnclosedElements()), annotation));
        return builder.build();
    }

    public TypeElement getSuperclassElement(Element element) {
        if (element instanceof Symbol.ClassSymbol) {
            return (TypeElement)((Object)((Symbol.ClassSymbol)element).getSuperclass().asElement());
        }
        return null;
    }

    private <T extends Element> Map<String, T> collectAnnotatedElements(Iterable<T> elements, Class<? extends Annotation> clazz) {
        ImmutableMap.Builder fields = ImmutableMap.builder();
        elements.forEach(e -> {
            if (e.getAnnotation(clazz) != null) {
                fields.put((Object)e.getSimpleName().toString(), e);
            }
        });
        return fields.build();
    }

    public MethodDocumentation getMethodDocumentation(ProcessingEnvironment processingEnv, Element element) {
        final StringBuilder parsedComment = new StringBuilder();
        final HashMap<String, String> parameters = new HashMap<String, String>();
        this.parseJavaDoc(processingEnv, element, new JavadocParseHandler(){

            @Override
            public void onParam(String param) {
                ExtensionAnnotationProcessor.this.parseMethodParameter(parameters, param);
            }

            @Override
            public void onBodyLine(String bodyLine) {
                parsedComment.append(bodyLine).append('\n');
            }
        });
        this.parseOperationParameterGroups(processingEnv, (Symbol.MethodSymbol)element, parameters);
        return new MethodDocumentation(ExtensionAnnotationProcessor.stripTags(parsedComment.toString()), parameters);
    }

    private void parseOperationParameterGroups(ProcessingEnvironment processingEnv, Symbol.MethodSymbol methodElement, Map<String, String> parameterDocs) {
        for (Symbol.VarSymbol parameterSymbol : methodElement.getParameters()) {
            for (Attribute.Compound compound : parameterSymbol.getAnnotationMirrors()) {
                Class annotationClass;
                DeclaredType annotationType = compound.getAnnotationType();
                if (annotationType == null || !ParameterGroup.class.isAssignableFrom(annotationClass = this.classFor((TypeElement)compound.getAnnotationType().asElement(), processingEnv).get())) continue;
                try {
                    this.getOperationParameterGroupDocumentation((TypeElement)processingEnv.getTypeUtils().asElement(parameterSymbol.asType()), parameterDocs, processingEnv);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void getOperationParameterGroupDocumentation(TypeElement groupElement, Map<String, String> parameterDocs, ProcessingEnvironment processingEnvironment) {
        this.getFieldsAnnotatedWith(groupElement, Parameter.class).forEach((key, value) -> parameterDocs.put((String)key, this.getJavaDocSummary(processingEnvironment, (Element)value)));
        this.getFieldsAnnotatedWith(groupElement, ParameterGroup.class).values().forEach(field -> this.getOperationParameterGroupDocumentation((TypeElement)processingEnvironment.getTypeUtils().asElement(field.asType()), parameterDocs, processingEnvironment));
    }

    public String getJavaDocSummary(ProcessingEnvironment processingEnv, Element element) {
        final StringBuilder parsedComment = new StringBuilder();
        this.parseJavaDoc(processingEnv, element, new JavadocParseHandler(){

            @Override
            public void onParam(String param) {
            }

            @Override
            public void onBodyLine(String bodyLine) {
                parsedComment.append(bodyLine).append('\n');
            }
        });
        return ExtensionAnnotationProcessor.stripTags(parsedComment.toString());
    }

    private static String stripTags(String comment) {
        StringBuilder builder = new StringBuilder();
        boolean insideTag = false;
        comment = comment.trim();
        int length = comment.length();
        for (int i = 0; i < length; ++i) {
            if (comment.charAt(i) == '{') {
                int nextCharIndex = i + 1;
                if (nextCharIndex < length && comment.charAt(nextCharIndex) == '@') {
                    while (comment.charAt(nextCharIndex) != ' ' && comment.charAt(nextCharIndex) != '}') {
                        nextCharIndex = i++;
                    }
                    insideTag = true;
                    i = nextCharIndex;
                    continue;
                }
            } else if (comment.charAt(i) == '}' && insideTag) {
                insideTag = false;
                continue;
            }
            builder.append(comment.charAt(i));
        }
        String strippedComments = builder.toString().trim();
        while (strippedComments.length() > 0 && strippedComments.charAt(strippedComments.length() - 1) == '\n') {
            strippedComments = StringUtils.chomp((String)strippedComments);
        }
        return strippedComments;
    }

    private void parseJavaDoc(ProcessingEnvironment processingEnv, Element element, JavadocParseHandler handler) {
        String comment = this.extractJavadoc(processingEnv, element);
        StringTokenizer st = new StringTokenizer(comment, "\n\r");
        while (st.hasMoreTokens()) {
            String nextToken = st.nextToken().trim();
            if (nextToken.isEmpty()) continue;
            if (nextToken.startsWith(PARAM)) {
                handler.onParam(nextToken);
                continue;
            }
            if (nextToken.charAt(0) == '@') continue;
            handler.onBodyLine(nextToken);
        }
    }

    private void parseMethodParameter(Map<String, String> parameters, String param) {
        String description;
        String paramName;
        int descriptionIndex = (param = param.replaceFirst(PARAM, "").trim()).indexOf(" ");
        if (descriptionIndex != -1) {
            paramName = param.substring(0, descriptionIndex).trim();
            description = param.substring(descriptionIndex).trim();
        } else {
            paramName = param;
            description = "";
        }
        parameters.put(paramName, ExtensionAnnotationProcessor.stripTags(description));
    }

    private String extractJavadoc(ProcessingEnvironment processingEnv, Element element) {
        String comment = processingEnv.getElementUtils().getDocComment(element);
        if (StringUtils.isBlank((CharSequence)comment)) {
            return "";
        }
        return comment.trim();
    }

    public <T> T getAnnotationValue(Element rootElement, Class<? extends Annotation> anAnnotation) {
        if (rootElement.getAnnotation(anAnnotation) != null) {
            String fullQualifiedAnnotationName = anAnnotation.getName();
            Reference annotationFieldValue = new Reference();
            rootElement.getAnnotationMirrors().stream().filter(annotationMirror -> fullQualifiedAnnotationName.equals(annotationMirror.getAnnotationType().toString())).forEach(annotationMirror -> annotationMirror.getElementValues().entrySet().stream().filter(entry -> VALUE.equals(((ExecutableElement)entry.getKey()).getSimpleName().toString())).findFirst().ifPresent(entry -> annotationFieldValue.set(((AnnotationValue)entry.getValue()).getValue())));
            return annotationFieldValue.get();
        }
        return null;
    }

    private static interface JavadocParseHandler {
        public void onParam(String var1);

        public void onBodyLine(String var1);
    }
}

