/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.schema.builder;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.spring.dsl.api.xml.SchemaConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.ExecutableTypeSchemaDelegate;
import org.mule.runtime.module.extension.internal.capability.xml.schema.builder.SchemaBuilder;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExplicitGroup;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.ExtensionType;
import org.mule.runtime.module.extension.internal.capability.xml.schema.model.TopLevelElement;
import org.mule.runtime.module.extension.internal.loader.java.property.ExtendingOperationModelProperty;

class OperationSchemaDelegate
extends ExecutableTypeSchemaDelegate {
    public OperationSchemaDelegate(SchemaBuilder builder) {
        super(builder);
    }

    public void registerOperation(OperationModel operationModel, DslElementSyntax dslSyntax) {
        String typeName = StringUtils.capitalize((String)operationModel.getName()) + "Type";
        this.registerProcessorElement(operationModel, typeName, dslSyntax);
        this.registerOperationType(typeName, operationModel, dslSyntax);
    }

    private void registerProcessorElement(OperationModel operationModel, String typeName, DslElementSyntax dslSyntax) {
        TopLevelElement element = new TopLevelElement();
        element.setName(dslSyntax.getElementName());
        element.setType(new QName(this.builder.getSchema().getTargetNamespace(), typeName));
        element.setAnnotation(this.builder.createDocAnnotation(operationModel.getDescription()));
        element.setSubstitutionGroup(this.getOperationSubstitutionGroup(operationModel));
        this.builder.getSchema().getSimpleTypeOrComplexTypeOrGroup().add(element);
    }

    private void registerOperationType(String name, OperationModel operationModel, DslElementSyntax dslSyntax) {
        ExtensionType operationType = this.createExecutableType(name, SchemaConstants.MULE_ABSTRACT_OPERATOR_TYPE, dslSyntax);
        this.initialiseSequence(operationType);
        ExplicitGroup sequence = operationType.getSequence();
        this.builder.addInfrastructureParameters(operationType, operationModel, sequence);
        operationModel.getParameterGroupModels().forEach(group -> this.registerParameterGroup(operationType, (ParameterGroupModel)group));
    }

    private QName getOperationSubstitutionGroup(OperationModel operationModel) {
        Reference<QName> substitutionGroup = new Reference<QName>(SchemaConstants.MULE_ABSTRACT_OPERATOR);
        operationModel.getModelProperty(ExtendingOperationModelProperty.class).ifPresent(property -> substitutionGroup.set(this.getSubstitutionGroup(property.getType())));
        return substitutionGroup.get();
    }
}

