/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class OperationParametersTypeModelValidator
implements ExtensionModelValidator {
    private final Set<String> forbiddenTypes = ImmutableSet.builder().add((Object)Event.class.getName()).add((Object)Message.class.getName()).build();

    @Override
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            @Override
            protected void onOperation(OperationModel model) {
                model.getAllParameterModels().forEach(parameterModel -> {
                    MetadataType parameterType = parameterModel.getType();
                    if (parameterType.getMetadataFormat().equals(MetadataFormat.JAVA) && this.isForbiddenType(parameterType)) {
                        problemsReporter.addError(new Problem(model, String.format("Operation '%s' contains parameter '%s' of type '%s' which is forbidden", model.getName(), parameterModel.getName(), MetadataTypeUtils.getTypeId(parameterType).get())));
                    }
                });
            }

            private boolean isForbiddenType(MetadataType parameterType) {
                return MetadataTypeUtils.getTypeId(parameterType).map(OperationParametersTypeModelValidator.this.forbiddenTypes::contains).orElse(false);
            }
        }.walk(extensionModel);
    }
}

