/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.resources;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.annotation.Extension;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.module.extension.internal.capability.xml.schema.ExtensionAnnotationProcessor;
import org.mule.runtime.module.extension.internal.resources.AnnotationProcessorResourceGenerator;

@SupportedAnnotationTypes(value={"org.mule.runtime.extension.api.annotation.Extension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedOptions(value={"extension.version"})
public abstract class BaseExtensionResourcesGeneratorAnnotationProcessor
extends AbstractProcessor {
    private static final ExtensionAnnotationProcessor processor = new ExtensionAnnotationProcessor();
    public static final String PROCESSING_ENVIRONMENT = "PROCESSING_ENVIRONMENT";
    public static final String EXTENSION_ELEMENT = "EXTENSION_ELEMENT";
    public static final String ROUND_ENVIRONMENT = "ROUND_ENVIRONMENT";
    public static final String EXTENSION_VERSION = "extension.version";
    private final SpiServiceRegistry serviceRegistry = new SpiServiceRegistry();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Starting Resources generator for Extensions");
        AnnotationProcessorResourceGenerator generator = new AnnotationProcessorResourceGenerator(this.fetchResourceFactories(), this.processingEnv);
        try {
            this.getExtension(roundEnv).ifPresent(extensionElement -> {
                Optional annotatedClass = processor.classFor((TypeElement)extensionElement, this.processingEnv);
                if (!annotatedClass.isPresent()) {
                    this.log("Extension class " + processor.getClassName((TypeElement)extensionElement, this.processingEnv) + " could not be found. Skipping");
                    return;
                }
                Class extensionClass = annotatedClass.get();
                ClassUtils.withContextClassLoader(extensionClass.getClassLoader(), () -> {
                    ExtensionModel extensionModel = this.parseExtension((TypeElement)extensionElement, roundEnv);
                    generator.generateFor(extensionModel);
                });
            });
            return false;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s\n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e)));
            throw e;
        }
    }

    private ExtensionModel parseExtension(TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        Class extensionClass = processor.classFor(extensionElement, this.processingEnv).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", extensionClass.getName());
        params.put("version", this.getVersion(extensionElement.getQualifiedName()));
        params.put(EXTENSION_ELEMENT, extensionElement);
        params.put(PROCESSING_ENVIRONMENT, this.processingEnv);
        params.put(ROUND_ENVIRONMENT, roundEnvironment);
        return this.getExtensionModelLoader().loadExtensionModel(extensionClass.getClassLoader(), DslResolvingContext.getDefault(Collections.emptySet()), params);
    }

    private Optional<TypeElement> getExtension(RoundEnvironment env) {
        Set<TypeElement> elements = processor.getTypeElementsAnnotatedWith(Extension.class, env);
        if (elements.size() > 1) {
            String message = String.format("Only one extension is allowed per plugin, however several classes annotated with @%s were found. Offending classes are [%s]", Extension.class.getSimpleName(), Joiner.on((String)", ").join((Iterable)elements.stream().map(TypeElement::getQualifiedName).collect(Collectors.toList())));
            throw new RuntimeException(message);
        }
        return elements.stream().findFirst();
    }

    private void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }

    private String getVersion(Name qualifiedName) {
        String extensionVersion = this.processingEnv.getOptions().get(EXTENSION_VERSION);
        if (extensionVersion == null) {
            throw new RuntimeException(String.format("Cannot resolve version for extension %s: option '%s' is missing.", qualifiedName, EXTENSION_VERSION));
        }
        return extensionVersion;
    }

    private List<GeneratedResourceFactory> fetchResourceFactories() {
        return ImmutableList.builder().addAll(this.serviceRegistry.lookupProviders(GeneratedResourceFactory.class, this.getClass().getClassLoader())).addAll(this.serviceRegistry.lookupProviders(DslResourceFactory.class, this.getClass().getClassLoader())).build();
    }

    protected abstract ExtensionModelLoader getExtensionModelLoader();
}

