/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.time.TimeSupplier;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.internal.loader.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.ImmutableExpirationPolicy;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationInstanceFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderToolingAdapter;
import org.mule.runtime.module.extension.internal.runtime.config.DynamicConfigurationProvider;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DefaultImplicitConfigurationProviderFactory
implements ImplicitConfigurationProviderFactory {
    @Inject
    private ConnectionManager connectionManager;
    @Inject
    private MuleMetadataService metadataService;

    @Override
    public ConfigurationProvider createImplicitConfigurationProvider(ExtensionModel extensionModel, ConfigurationModel implicitConfigurationModel, Event event, MuleContext muleContext) {
        if (implicitConfigurationModel == null || !ExtensionModelUtils.canBeUsedImplicitly(implicitConfigurationModel)) {
            throw new IllegalStateException("Could not find a config for extension '" + extensionModel.getName() + "' and none can be created automatically. Please define one");
        }
        String providerName = MuleExtensionUtils.getImplicitConfigurationProviderName(extensionModel, implicitConfigurationModel);
        Callable<ResolverSet> resolverSetCallable = () -> ImplicitObjectUtils.buildImplicitResolverSet(implicitConfigurationModel, muleContext);
        ResolverSet resolverSet = ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(extensionModel), resolverSetCallable);
        try {
            ImplicitConnectionProviderValueResolver implicitConnectionProviderValueResolver = new ImplicitConnectionProviderValueResolver(implicitConfigurationModel.getName(), extensionModel, implicitConfigurationModel, muleContext);
            ConfigurationInstance configurationInstance = new ConfigurationInstanceFactory(extensionModel, implicitConfigurationModel, resolverSet, muleContext).createConfiguration(providerName, event, implicitConnectionProviderValueResolver);
            if (resolverSet.isDynamic() || this.needsDynamicConnectionProvider(extensionModel, implicitConfigurationModel, implicitConnectionProviderValueResolver)) {
                return new DynamicConfigurationProvider(providerName, extensionModel, implicitConfigurationModel, resolverSet, implicitConnectionProviderValueResolver, ImmutableExpirationPolicy.getDefault(new TimeSupplier()), muleContext);
            }
            return new ConfigurationProviderToolingAdapter(providerName, extensionModel, implicitConfigurationModel, configurationInstance, muleContext);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private boolean needsDynamicConnectionProvider(ExtensionModel extensionModel, ConfigurationModel configurationModel, ImplicitConnectionProviderValueResolver implicitConnectionProviderValueResolver) {
        return !ExtensionModelUtils.getConnectedComponents(extensionModel, configurationModel).isEmpty() && implicitConnectionProviderValueResolver.isDynamic();
    }
}

