/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private final boolean returnsListOfMessages;
    private final CursorProviderFactory cursorProviderFactory;

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages(componentModel);
        this.muleContext = muleContext;
        this.cursorProviderFactory = cursorProviderFactory;
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        MediaType mediaType = this.resolveMediaType(value, operationContext);
        Event event = operationContext.getEvent();
        if (value instanceof Result) {
            return MessageUtils.toMessage((Result)value, mediaType, this.cursorProviderFactory, event);
        }
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = MessageUtils.toMessageCollection((Collection)value, this.cursorProviderFactory, event);
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            value = MessageUtils.toMessageIterator((Iterator)value, this.cursorProviderFactory, event);
        }
        return Message.builder().payload(StreamingUtils.streamingContent(value, this.cursorProviderFactory, event)).mediaType(mediaType).build();
    }

    private MediaType resolveMediaType(Object value, ExecutionContextAdapter<ComponentModel> operationContext) {
        Optional<MediaType> optionalMediaType;
        Charset existingEncoding = SystemUtils.getDefaultEncoding(this.muleContext);
        MediaType mediaType = null;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = mediaType.getCharset().get();
        }
        if (mediaType == null) {
            mediaType = MediaType.ANY;
        }
        if (operationContext.hasParameter("outputMimeType")) {
            mediaType = MediaType.parse((String)operationContext.getParameter("outputMimeType"));
        }
        mediaType = operationContext.hasParameter("outputEncoding") ? mediaType.withCharset(Charset.forName((String)operationContext.getParameter("outputEncoding"))) : mediaType.withCharset(existingEncoding);
        return mediaType;
    }
}

