/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.ParametersResolverProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.internal.policy.OperationExecutionFunction;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionTypeMapper;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.mule.runtime.module.extension.internal.runtime.operation.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.PrecalculatedExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OperationMessageProcessor
extends ExtensionComponent<OperationModel>
implements Processor,
ParametersResolverProcessor,
EntityMetadataProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Flow '%s' defines an invalid usage of operation '%s' which uses %s as target";
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final ResolverSet resolverSet;
    private final String target;
    private final EntityMetadataMediator entityMetadataMediator;
    private ExecutionMediator executionMediator;
    private OperationExecutor operationExecutor;
    private PolicyManager policyManager;
    protected ReturnDelegate returnDelegate;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, ExtensionManager extensionManager, PolicyManager policyManager) {
        super(extensionModel, operationModel, configurationProvider, cursorProviderFactory, extensionManager);
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.entityMetadataMediator = new EntityMetadataMediator(operationModel);
        this.policyManager = policyManager;
    }

    @Override
    public Event process(Event event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<Event> apply(Publisher<Event> publisher) {
        return Flux.from(publisher).flatMap(Exceptions.checkedFunction(event -> ClassUtils.withContextClassLoader(this.classLoader, () -> {
            OperationExecutionFunction operationExecutionFunction;
            Optional<ConfigurationInstance> configuration;
            if (event.getParameters().containsKey("core:interceptionResolvedContext")) {
                PrecalculatedExecutionContextAdapter operationContext = this.getPrecalculatedContext((Event)event);
                configuration = operationContext.getConfiguration();
                operationExecutionFunction = (parameters, operationEvent) -> this.doProcess(operationEvent, operationContext);
            } else {
                configuration = this.getConfiguration((Event)event);
                operationExecutionFunction = (parameters, operationEvent) -> {
                    ExecutionContextAdapter<OperationModel> operationContext;
                    try {
                        operationContext = this.createExecutionContext(configuration, parameters, operationEvent);
                    }
                    catch (MuleException e2) {
                        return Flux.error((Throwable)e2);
                    }
                    return this.doProcess(operationEvent, operationContext).onErrorMap(e -> !(e instanceof MessagingException), e -> {
                        if (this.operationModel.isBlocking()) {
                            return new MessagingException((Event)event, (Throwable)e);
                        }
                        return new MessagingException((Event)event, (Throwable)e, (Processor)this);
                    });
                };
            }
            if (this.getLocation() != null) {
                return this.policyManager.createOperationPolicy(this.getLocation(), (Event)event, this.getResolutionResult((Event)event, configuration), operationExecutionFunction).process((Event)event);
            }
            return operationExecutionFunction.execute(this.getResolutionResult((Event)event, configuration), (Event)event);
        }, MuleException.class, e -> {
            throw new DefaultMuleException(e);
        })));
    }

    private PrecalculatedExecutionContextAdapter getPrecalculatedContext(Event event) {
        return (PrecalculatedExecutionContextAdapter)event.getParameters().get("core:interceptionResolvedContext").getValue();
    }

    protected Mono<Event> doProcess(Event event, ExecutionContextAdapter<OperationModel> operationContext) {
        return this.executeOperation(operationContext).map(value -> this.returnDelegate.asReturnValue(value, operationContext)).switchIfEmpty(Mono.fromCallable(() -> this.returnDelegate.asReturnValue(null, operationContext))).onErrorMap(Exceptions::unwrap);
    }

    private Mono<Object> executeOperation(ExecutionContextAdapter operationContext) {
        return Mono.from(this.executionMediator.execute(this.operationExecutor, operationContext));
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, Event event) throws MuleException {
        return new DefaultExecutionContext<OperationModel>(this.extensionModel, configuration, resolvedParameters, this.operationModel, event, this.getCursorProviderFactory(), this.streamingManager, this.flowConstruct, this.getLocation(), this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.returnDelegate = this.createReturnDelegate();
        this.operationExecutor = MuleExtensionUtils.getOperationExecutorFactory(this.operationModel).createExecutor(this.operationModel);
        this.executionMediator = this.createExecutionMediator();
        LifecycleUtils.initialiseIfNeeded(this.resolverSet, this.muleContext);
        LifecycleUtils.initialiseIfNeeded((Object)this.operationExecutor, true, this.muleContext);
    }

    private ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid(this.operationModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? new ValueReturnDelegate(this.operationModel, this.getCursorProviderFactory(), this.muleContext) : new TargetReturnDelegate(this.target, this.operationModel, this.getCursorProviderFactory(), this.muleContext);
    }

    private boolean isTargetPresent() {
        if (StringUtils.isBlank((CharSequence)this.target)) {
            return false;
        }
        if (this.target.startsWith("flowVars")) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), String.format("the '%s' prefix", "flowVars")));
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), "an expression"));
        }
        return true;
    }

    protected Optional<String> getTarget() {
        return this.isTargetPresent() ? Optional.of(this.target) : Optional.empty();
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded(this.operationExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.operationExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded(this.operationExecutor, LOGGER);
    }

    @Override
    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.entityMetadataMediator.getEntityKeys((MetadataContext)context)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    @Override
    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        try {
            return this.runWithMetadataContext(context -> ClassUtils.withContextClassLoader(this.classLoader, () -> this.entityMetadataMediator.getEntityMetadata((MetadataContext)context, key)));
        }
        catch (ConnectionException e) {
            return MetadataResult.failure(MetadataFailure.Builder.newFailure(e).onKeys());
        }
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator(this.extensionModel, this.operationModel, this.connectionManager, this.muleContext.getErrorTypeRepository());
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(this.operationModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(this.operationModel.getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Flow '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.flowConstruct.getName(), this.operationModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        Event event = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new OperationParameterValueResolver(new LazyExecutionContext<OperationModel>(this.resolverSet, this.operationModel, this.extensionModel, ValueResolvingContext.from(event)));
    }

    @Override
    public ReactiveProcessor.ProcessingType getProcessingType() {
        ReactiveProcessor.ProcessingType processingType = ExecutionTypeMapper.asProcessingType(this.operationModel.getExecutionType());
        if (processingType == ReactiveProcessor.ProcessingType.CPU_LITE && !this.operationModel.isBlocking()) {
            return ReactiveProcessor.ProcessingType.CPU_LITE_ASYNC;
        }
        return processingType;
    }

    @Override
    public ParametersResolverProcessor.ParametersResolverProcessorResult resolveParameters(Event event) throws MuleException {
        if (this.operationExecutor instanceof OperationArgumentResolverFactory) {
            List<Interceptor> interceptors;
            DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
            PrecalculatedExecutionContextAdapter executionContext = new PrecalculatedExecutionContextAdapter(this.createExecutionContext(event), this.operationExecutor);
            InterceptorsExecutionResult beforeExecutionResult = mediator.before(executionContext, interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext.getOperationExecutor()));
            if (beforeExecutionResult.isOk()) {
                Map<String, Object> resolvedArguments = ((OperationArgumentResolverFactory)((Object)this.operationExecutor)).createArgumentResolver(this.operationModel).apply(executionContext);
                return new ParametersResolverProcessor.ParametersResolverProcessorResult(resolvedArguments, executionContext);
            }
            this.disposeResolvedParameters(executionContext, interceptors);
            throw new DefaultMuleException("Interception execution for operation not ok", beforeExecutionResult.getThrowable());
        }
        return new ParametersResolverProcessor.ParametersResolverProcessorResult(Collections.emptyMap(), null);
    }

    @Override
    public void disposeResolvedParameters(ExecutionContext<OperationModel> executionContext) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        List<Interceptor> interceptors = mediator.collectInterceptors(executionContext.getConfiguration(), executionContext instanceof PrecalculatedExecutionContextAdapter ? ((PrecalculatedExecutionContextAdapter)executionContext).getOperationExecutor() : this.operationExecutor);
        this.disposeResolvedParameters(executionContext, interceptors);
    }

    private void disposeResolvedParameters(ExecutionContext<OperationModel> executionContext, List<Interceptor> interceptors) {
        DefaultExecutionMediator mediator = (DefaultExecutionMediator)this.executionMediator;
        mediator.after(executionContext, null, interceptors);
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(Event event) throws MuleException {
        Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
        return this.createExecutionContext(configuration, this.getResolutionResult(event, configuration), event);
    }

    private Map<String, Object> getResolutionResult(Event event, Optional<ConfigurationInstance> configuration) throws MuleException {
        return this.resolverSet.resolve(ValueResolvingContext.from(event, configuration)).asMap();
    }
}

