/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.function.Consumer;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.execution.ExceptionCallback;
import org.mule.runtime.core.internal.execution.ResponseCompletionCallback;

class ExtensionSourceExceptionCallback
implements ExceptionCallback {
    private final ResponseCompletionCallback completionCallback;
    private final Event event;
    private final Consumer<MessagingException> errorResponseHandler;
    private final MessageProcessContext messageProcessorContext;

    public ExtensionSourceExceptionCallback(ResponseCompletionCallback completionCallback, Event event, Consumer<MessagingException> errorResponseCallback, MessageProcessContext messageProcessContext) {
        this.completionCallback = completionCallback;
        this.event = event;
        this.errorResponseHandler = errorResponseCallback;
        this.messageProcessorContext = messageProcessContext;
    }

    public void onException(Throwable exception) {
        MessagingException messagingException = exception instanceof MessagingException ? (MessagingException)exception : new MessagingException(this.event, exception);
        Event errorEvent = ExceptionUtils.createErrorEvent(this.event, this.messageProcessorContext.getMessageSource(), messagingException, this.messageProcessorContext.getErrorTypeLocator());
        messagingException.setProcessedEvent(errorEvent);
        Event errorHandlingEvent = this.completionCallback.responseSentWithFailure(messagingException, errorEvent);
        messagingException.setProcessedEvent(errorHandlingEvent);
        this.errorResponseHandler.accept(messagingException);
    }
}

