/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.runtime.operation;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.DefaultTransformationService;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.extension.api.soap.SoapAttachment;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;
import org.mule.runtime.soap.api.message.SoapRequest;
import org.mule.runtime.soap.api.message.SoapRequestBuilder;
import org.mule.runtime.soap.api.message.SoapResponse;
import org.mule.runtime.soap.internal.exception.error.SoapExceptionEnricher;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class SoapOperationExecutor
implements OperationExecutor {
    @Inject
    private MuleExpressionLanguage expressionExecutor;
    @Inject
    private DefaultTransformationService transformationService;
    private final ConnectionArgumentResolver connectionResolver = new ConnectionArgumentResolver();
    private final SoapExceptionEnricher soapExceptionEnricher = new SoapExceptionEnricher();

    @Override
    public Publisher<Object> execute(ExecutionContext<OperationModel> context) {
        try {
            String serviceId = (String)context.getParameter("service");
            ForwardingSoapClient connection = (ForwardingSoapClient)this.connectionResolver.resolve(context);
            Map<String, String> customHeaders = connection.getCustomHeaders(serviceId, this.getOperation(context));
            SoapRequest request = this.getRequest(context, customHeaders);
            SoapResponse response = connection.getSoapClient(serviceId).consume(request);
            return Mono.justOrEmpty(response.getAsResult());
        }
        catch (MessagingException | MessageTransformerException | TransformerException e) {
            return Mono.error((Throwable)e);
        }
        catch (Exception e) {
            return Mono.error((Throwable)this.soapExceptionEnricher.enrich(e));
        }
        catch (Throwable t) {
            return Mono.error((Throwable)Exceptions.wrapFatal(t));
        }
    }

    private SoapRequest getRequest(ExecutionContext<OperationModel> context, Map<String, String> fixedHeaders) throws MessageTransformerException, MessagingException, TransformerException {
        SoapRequestBuilder builder = SoapRequest.builder().withOperation(this.getOperation(context));
        builder.withSoapHeaders(fixedHeaders);
        Optional optionalMessageGroup = this.getParam(context, "Message");
        if (optionalMessageGroup.isPresent()) {
            Map attachments;
            InputStream headers;
            Map message = (Map)optionalMessageGroup.get();
            InputStream body2 = (InputStream)message.get("body");
            if (body2 != null) {
                builder.withContent(body2);
            }
            if ((headers = (InputStream)message.get("headers")) != null) {
                builder.withSoapHeaders((Map)this.evaluateHeaders(headers));
            }
            if ((attachments = (Map)message.get("attachments")) != null) {
                this.toSoapAttachments(attachments).forEach(builder::withAttachment);
            }
        }
        this.getParam(context, "transportHeaders").ifPresent(th -> builder.withTransportHeaders((Map)th));
        return builder.build();
    }

    private String getOperation(ExecutionContext<OperationModel> context) {
        return (String)this.getParam(context, "operation").orElseThrow(() -> new IllegalStateException("Execution Context does not have the required operation parameter"));
    }

    private <T> Optional<T> getParam(ExecutionContext<OperationModel> context, String param) {
        return context.hasParameter(param) ? Optional.ofNullable(context.getParameter(param)) : Optional.empty();
    }

    private Object evaluateHeaders(InputStream headers) {
        String hs = IOUtils.toString(headers);
        BindingContext context = BindingContext.builder().addBinding("payload", new TypedValue<String>(hs, DataType.XML_STRING)).build();
        return this.expressionExecutor.evaluate("%dw 2.0 \noutput application/java \n---\npayload.headers mapObject (value, key) -> {\n    '$key' : write((key): value, \"application/xml\")\n}", context).getValue();
    }

    private Map<String, SoapAttachment> toSoapAttachments(Map<String, TypedValue<?>> attachments) throws MessageTransformerException, MessagingException, TransformerException {
        HashMap<String, SoapAttachment> soapAttachmentMap = new HashMap<String, SoapAttachment>();
        for (Map.Entry<String, TypedValue<?>> attachment : attachments.entrySet()) {
            SoapAttachment soapAttachment = new SoapAttachment(this.toInputStream(attachment.getValue()), attachment.getValue().getDataType().getMediaType());
            soapAttachmentMap.put(attachment.getKey(), soapAttachment);
        }
        return soapAttachmentMap;
    }

    private InputStream toInputStream(TypedValue typedValue) throws MessageTransformerException, MessagingException, TransformerException {
        Object value = typedValue.getValue();
        if (value instanceof InputStream) {
            return (InputStream)value;
        }
        return (InputStream)this.transformationService.internalTransform(value, DataType.fromObject(value), DataType.INPUT_STREAM);
    }
}

