/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.ts;

import java.io.Serializable;
import org.mule.weave.v2.parser.InvalidMethodTypesMessage$;
import org.mule.weave.v2.parser.InvalidTypeMessage$;
import org.mule.weave.v2.parser.Message;
import org.mule.weave.v2.parser.NotEnoughArgumentMessage$;
import org.mule.weave.v2.parser.TooManyArgumentMessage$;
import org.mule.weave.v2.parser.TypeCoercedMessage$;
import org.mule.weave.v2.parser.ast.AstNode;
import org.mule.weave.v2.parser.ast.functions.FunctionCallNode;
import org.mule.weave.v2.parser.ast.variables.NameIdentifier;
import org.mule.weave.v2.parser.ast.variables.VariableReferenceNode;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.ConstrainProblem;
import org.mule.weave.v2.ts.Constraint;
import org.mule.weave.v2.ts.Constraint$;
import org.mule.weave.v2.ts.ConstraintResult;
import org.mule.weave.v2.ts.ConstraintSet;
import org.mule.weave.v2.ts.CustomTypeResolver;
import org.mule.weave.v2.ts.DynamicReturnType;
import org.mule.weave.v2.ts.Edge;
import org.mule.weave.v2.ts.EdgeLabels$;
import org.mule.weave.v2.ts.ErrorResult;
import org.mule.weave.v2.ts.FunctionType;
import org.mule.weave.v2.ts.FunctionType$;
import org.mule.weave.v2.ts.FunctionTypeParameter;
import org.mule.weave.v2.ts.FunctionTypeParameter$;
import org.mule.weave.v2.ts.NoSolutionSet;
import org.mule.weave.v2.ts.NothingType;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.SolutionResult;
import org.mule.weave.v2.ts.Substitution;
import org.mule.weave.v2.ts.Substitution$;
import org.mule.weave.v2.ts.TypeCoercer$;
import org.mule.weave.v2.ts.TypeHelper$;
import org.mule.weave.v2.ts.TypeNode;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.ts.WeaveTypeResolutionContext;
import org.mule.weave.v2.ts.WeaveTypeResolver;
import org.mule.weave.v2.utils.IdentityHashMap;
import org.mule.weave.v2.utils.IdentityHashMap$;
import org.mule.weave.v2.utils.SeqUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Either;

public final class FunctionCallNodeResolver$
implements WeaveTypeResolver {
    public static FunctionCallNodeResolver$ MODULE$;

    static {
        new FunctionCallNodeResolver$();
    }

    @Override
    public boolean supportsPartialResolution() {
        return WeaveTypeResolver.supportsPartialResolution$(this);
    }

    @Override
    public Option<WeaveType> execute(TypeNode node, WeaveTypeResolutionContext ctx) {
        Edge functionReference = (Edge)node.incomingEdges().head();
        WeaveType functionType = functionReference.incomingType();
        Seq parameters = (Seq)node.incomingEdges().filter((Function1 & Serializable & scala.Serializable)edge -> BoxesRunTime.boxToBoolean((boolean)FunctionCallNodeResolver$.$anonfun$execute$18(edge)));
        Seq parameterTypes = (Seq)parameters.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.incomingType(), Seq$.MODULE$.canBuildFrom());
        return this.resolveFunctionType(node, ctx, functionType, (Seq<WeaveType>)parameterTypes);
    }

    private Option<WeaveType> resolveFunctionType(TypeNode node, WeaveTypeResolutionContext ctx, WeaveType functionType, Seq<WeaveType> parameterTypes) {
        Some some;
        block7: {
            WeaveType weaveType;
            while (true) {
                TypeParameter typeParameter;
                Option<WeaveType> option;
                if ((weaveType = functionType) instanceof FunctionType) {
                    FunctionType functionType2 = (FunctionType)weaveType;
                    Seq<FunctionTypeParameter> args = functionType2.params();
                    some = this.validateParametersCount(node, parameterTypes, args, ctx) ? this.resolveReturnType(functionType2, node, parameterTypes, ctx) : None$.MODULE$;
                    break block7;
                }
                if (weaveType instanceof TypeParameter && (option = (typeParameter = (TypeParameter)weaveType).baseType()) instanceof Some) {
                    WeaveType baseType;
                    Some some2 = (Some)option;
                    functionType = baseType = (WeaveType)some2.value();
                    continue;
                }
                if (weaveType instanceof UnionType) {
                    UnionType unionType = (UnionType)weaveType;
                    Seq<WeaveType> of = unionType.of();
                    Seq options = (Seq)of.map((Function1 & Serializable & scala.Serializable)t -> this.resolveFunctionType(node, ctx, (WeaveType)t, parameterTypes), Seq$.MODULE$.canBuildFrom());
                    some = options.exists((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)x$18.isEmpty())) ? None$.MODULE$ : new Some((Object)TypeHelper$.MODULE$.unify((Seq<WeaveType>)((Seq)options.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo)))));
                    break block7;
                }
                if (!(weaveType instanceof ReferenceType)) break;
                ReferenceType referenceType = (ReferenceType)weaveType;
                functionType = referenceType.resolveType();
            }
            if (weaveType instanceof NothingType) {
                NothingType nothingType = (NothingType)weaveType;
                some = new Some((Object)nothingType);
            } else {
                FunctionType expectedType = new FunctionType((Seq<FunctionTypeParameter>)((Seq)parameterTypes.map((Function1 & Serializable & scala.Serializable)x$19 -> new FunctionTypeParameter("arg", (WeaveType)x$19, FunctionTypeParameter$.MODULE$.apply$default$3()), Seq$.MODULE$.canBuildFrom())), new AnyType(), FunctionType$.MODULE$.apply$default$3(), FunctionType$.MODULE$.apply$default$4(), FunctionType$.MODULE$.apply$default$5());
                if (!TypeHelper$.MODULE$.canBeAssignedTo(functionType, expectedType, ctx, TypeHelper$.MODULE$.canBeAssignedTo$default$4())) {
                    node.error(InvalidTypeMessage$.MODULE$.apply(expectedType, functionType));
                }
                some = None$.MODULE$;
            }
        }
        return some;
    }

    private boolean validateParametersCount(TypeNode node, Seq<WeaveType> parameterTypes, Seq<FunctionTypeParameter> args, WeaveTypeResolutionContext ctx) {
        boolean bl;
        Seq requiredArgumentTypes = (Seq)args.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)FunctionCallNodeResolver$.$anonfun$validateParametersCount$1(x$20)));
        if (parameterTypes.size() > args.size()) {
            node.error(TooManyArgumentMessage$.MODULE$.apply((Seq<WeaveType>)((Seq)args.map((Function1 & Serializable & scala.Serializable)x$21 -> x$21.wtype(), Seq$.MODULE$.canBuildFrom())), parameterTypes));
            bl = false;
        } else if (parameterTypes.size() < requiredArgumentTypes.size()) {
            node.error(NotEnoughArgumentMessage$.MODULE$.apply((Seq<WeaveType>)((Seq)requiredArgumentTypes.map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.wtype(), Seq$.MODULE$.canBuildFrom())), parameterTypes));
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    public Option<WeaveType> resolveReturnType(FunctionType ft, TypeNode node, Seq<WeaveType> invokedArguments, WeaveTypeResolutionContext ctx) {
        Object object;
        Seq definitions = ft.overloads().isEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FunctionType[]{ft})) : ft.overloads();
        Seq<FunctionTypeParameter> params = ft.params();
        Seq<WeaveType> expandedArguments = this.expandWithDefaultValues(invokedArguments, params);
        Seq expandedTypes = (Seq)expandedArguments.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            WeaveType weaveType = x0$1;
            if (weaveType instanceof UnionType) {
                Seq of;
                UnionType unionType = (UnionType)weaveType;
                seq = of = unionType.of();
            } else {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WeaveType[]{weaveType}));
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
        Seq[] typeCombinations = (Seq[])SeqUtils$.MODULE$.combine(expandedTypes).toArray(ClassTag$.MODULE$.apply(Seq.class));
        Seq responseTypes = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])typeCombinations)).map((Function1 & Serializable & scala.Serializable)typeCombination -> this.resolve(node, (Seq<FunctionType>)definitions, (Seq<WeaveType>)typeCombination, ctx), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        if (responseTypes.exists((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.isRight()))) {
            String name = (String)ft.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> this.calculateFunctionName(node));
            Seq problems = (Seq)responseTypes.flatMap((Function1 & Serializable & scala.Serializable)x$24 -> Option$.MODULE$.option2Iterable(x$24.right().toOption()), Seq$.MODULE$.canBuildFrom());
            problems.foreach((Function1 & Serializable & scala.Serializable)problem -> {
                node.error(InvalidMethodTypesMessage$.MODULE$.apply(name, (Seq<WeaveType>)expandedArguments, (Seq<Tuple2<FunctionType, Seq<Message>>>)problem));
                return BoxedUnit.UNIT;
            });
            object = None$.MODULE$;
        } else {
            Seq returnTypes = (Seq)((TraversableLike)responseTypes.flatMap((Function1 & Serializable & scala.Serializable)x$25 -> Option$.MODULE$.option2Iterable(x$25.left().toOption()), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToBoolean((boolean)FunctionCallNodeResolver$.$anonfun$resolveReturnType$8(x$26)));
            object = returnTypes.isEmpty() ? None$.MODULE$ : new Some((Object)TypeHelper$.MODULE$.unify((Seq<WeaveType>)returnTypes));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<WeaveType> expandWithDefaultValues(Seq<WeaveType> invokedArguments, Seq<FunctionTypeParameter> params) {
        void var3_3;
        Seq expandedArguments = params.size() != invokedArguments.size() ? (((FunctionTypeParameter)params.head()).optional() ? (Seq)((TraversableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)param -> {
            int delta;
            int index = param._2$mcI$sp();
            return index < (delta = params.length() - invokedArguments.size()) ? ((FunctionTypeParameter)param._1()).wtype() : (WeaveType)invokedArguments.apply(index - delta);
        }, Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)params.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)param -> {
            int index = param._2$mcI$sp();
            return invokedArguments.size() > index ? (WeaveType)invokedArguments.apply(index) : ((FunctionTypeParameter)param._1()).wtype();
        }, Seq$.MODULE$.canBuildFrom())) : invokedArguments;
        return var3_3;
    }

    public String calculateFunctionName(TypeNode node) {
        String string;
        AstNode astNode = node.astNode();
        if (astNode instanceof FunctionCallNode) {
            String string2;
            AstNode astNode2 = ((Edge)node.incomingEdges().head()).source().astNode();
            if (astNode2 instanceof VariableReferenceNode) {
                VariableReferenceNode variableReferenceNode = (VariableReferenceNode)astNode2;
                NameIdentifier variable = variableReferenceNode.variable();
                string2 = variable.name();
            } else {
                string2 = "AnonymousFunction";
            }
            string = string2;
        } else {
            string = "AnonymousFunction";
        }
        return string;
    }

    private Either<WeaveType, Seq<Tuple2<FunctionType, Seq<Message>>>> resolve(TypeNode node, Seq<FunctionType> operators, Seq<WeaveType> actualTypes, WeaveTypeResolutionContext ctx) {
        Either<WeaveType, Seq<Tuple2<FunctionType, Seq<Message>>>> matchedOperator = this.resolveReturnType(operators, actualTypes, node, ctx, this.resolveReturnType$default$5());
        return matchedOperator.isRight() ? this.resolveReturnType(operators, actualTypes, node, ctx, true) : matchedOperator;
    }

    private WeaveType substituteResult(Substitution substitution, WeaveType returnType, WeaveTypeResolutionContext ctx, IdentityHashMap<TypeParameter, TypeParameter> typeParameterReplacement) {
        WeaveType substitute2 = Constraint$.MODULE$.substitute(returnType, substitution, ctx, true);
        Substitution originalTypeParamSubstitution = Substitution$.MODULE$.apply(IdentityHashMap$.MODULE$.apply((Seq)typeParameterReplacement.toSeq().map((Function1 & Serializable & scala.Serializable)entry -> new Tuple2(entry._2(), entry._1()), Seq$.MODULE$.canBuildFrom())));
        WeaveType withOriginalTypeParameter = Constraint$.MODULE$.substitute(substitute2, originalTypeParamSubstitution, ctx, false);
        Seq<TypeParameter> parameters = TypeHelper$.MODULE$.collectTypeParameters(returnType);
        return TypeHelper$.MODULE$.cleanupUnionTypeWithParameters(withOriginalTypeParameter, parameters);
    }

    private Either<WeaveType, Seq<Tuple2<FunctionType, Seq<Message>>>> resolveReturnType(Seq<FunctionType> functions, Seq<WeaveType> actualTypes, TypeNode node, WeaveTypeResolutionContext ctx, boolean coerce) {
        None$ result = None$.MODULE$;
        IdentityHashMap<TypeParameter, TypeParameter> typeParameterReplacement = IdentityHashMap$.MODULE$.apply(Nil$.MODULE$);
        Seq actualTypeWithFreshTypeParameters = (Seq)actualTypes.map((Function1 & Serializable & scala.Serializable)wt -> TypeHelper$.MODULE$.toFreshTypeParameters((WeaveType)wt, (Map<TypeParameter, TypeParameter>)typeParameterReplacement), Seq$.MODULE$.canBuildFrom());
        ObjectRef collectedProblems = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
        Iterator functionTypes = functions.iterator();
        while (functionTypes.hasNext() && result.isEmpty()) {
            BoxedUnit boxedUnit;
            FunctionType functionType = (FunctionType)functionTypes.next();
            ObjectRef warningMessages = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            ObjectRef calledArguments = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            Seq argTypes = (Seq)functionType.params().map((Function1 & Serializable & scala.Serializable)x$27 -> x$27.wtype(), Seq$.MODULE$.canBuildFrom());
            ConstraintSet constraintSet = (ConstraintSet)((TraversableOnce)((TraversableLike)argTypes.zip((GenIterable)actualTypeWithFreshTypeParameters, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ConstraintSet constraintSet;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    WeaveType actualType;
                    WeaveType argType = (WeaveType)tuple2._1();
                    ConstraintSet constrains = Constraint$.MODULE$.collectConstrains(argType, actualType = (WeaveType)tuple2._2(), ctx, Constraint$.MODULE$.collectConstrains$default$4());
                    ConstraintSet constraintSet2 = constrains;
                    if (constraintSet2 instanceof NoSolutionSet && coerce) {
                        ConstraintSet constraintSet3;
                        Option<WeaveType> maybeType = TypeCoercer$.MODULE$.coerce(argType, actualType, ctx);
                        Option<WeaveType> option = maybeType;
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            WeaveType coercedArg = (WeaveType)some.value();
                            warningMessages$1.elem = (Seq)((Seq)warningMessages$1.elem).$colon$plus((Object)TypeCoercedMessage$.MODULE$.apply(argType, actualType), Seq$.MODULE$.canBuildFrom());
                            calledArguments$1.elem = (Seq)((Seq)calledArguments$1.elem).$colon$plus((Object)coercedArg, Seq$.MODULE$.canBuildFrom());
                            constraintSet3 = Constraint$.MODULE$.collectConstrains(argType, coercedArg, ctx, Constraint$.MODULE$.collectConstrains$default$4());
                        } else if (None$.MODULE$.equals(option)) {
                            constraintSet3 = constrains;
                        } else {
                            throw new MatchError(option);
                        }
                        constraintSet = constraintSet3;
                    } else {
                        calledArguments$1.elem = (Seq)((Seq)calledArguments$1.elem).$colon$plus((Object)actualType, Seq$.MODULE$.canBuildFrom());
                        constraintSet = constrains;
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                ConstraintSet constraintSet4 = constraintSet;
                return constraintSet4;
            }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)new ConstrainProblem((Seq<Constraint>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))), (Function2 & Serializable & scala.Serializable)(x$28, x$29) -> x$28.merge((Function0<ConstraintSet>)(Function0 & Serializable & scala.Serializable)() -> x$29));
            ConstraintSet constraintSet2 = constraintSet;
            if (constraintSet2 instanceof NoSolutionSet) {
                NoSolutionSet noSolutionSet = (NoSolutionSet)constraintSet2;
                Seq<Message> problems = noSolutionSet.problems();
                collectedProblems.elem = (Seq)((Seq)collectedProblems.elem).$colon$plus((Object)new Tuple2((Object)functionType, problems), Seq$.MODULE$.canBuildFrom());
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            if (constraintSet2 instanceof ConstrainProblem) {
                BoxedUnit boxedUnit2;
                ConstraintResult solution = constraintSet.resolve(ctx, coerce, constraintSet.resolve$default$3(), constraintSet.resolve$default$4());
                ConstraintResult constraintResult = solution;
                if (constraintResult instanceof ErrorResult) {
                    ErrorResult errorResult = (ErrorResult)constraintResult;
                    Seq<Message> problems = errorResult.problems();
                    collectedProblems.elem = (Seq)((Seq)collectedProblems.elem).$colon$plus((Object)new Tuple2((Object)functionType, problems), Seq$.MODULE$.canBuildFrom());
                    boxedUnit2 = BoxedUnit.UNIT;
                } else if (constraintResult instanceof SolutionResult) {
                    BoxedUnit boxedUnit3;
                    SolutionResult solutionResult = (SolutionResult)constraintResult;
                    Substitution substitution = solutionResult.substitution();
                    Seq<Message> warnings = solutionResult.warnings();
                    ((IterableLike)((Seq)warningMessages.elem).$plus$plus(warnings, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)warMessage -> {
                        node.warning(warMessage);
                        return BoxedUnit.UNIT;
                    });
                    Option<CustomTypeResolver> option = functionType.customReturnTypeResolver();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        CustomTypeResolver crtr = (CustomTypeResolver)some.value();
                        result = crtr.resolve((Seq<WeaveType>)((Seq)calledArguments.elem), ctx, node).map((Function1 & Serializable & scala.Serializable)x$30 -> this.substituteResult(substitution, (WeaveType)x$30, ctx, typeParameterReplacement));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        WeaveType returnType = functionType.returnType();
                        result = new Some((Object)this.substituteResult(substitution, returnType, ctx, typeParameterReplacement));
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)constraintResult);
                }
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError((Object)constraintSet2);
        }
        return (Either)result.map((Function1 & Serializable & scala.Serializable)x$31 -> package$.MODULE$.Left().apply(x$31)).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)((Seq)collectedProblems$1.elem)));
    }

    private boolean resolveReturnType$default$5() {
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$execute$18(Edge edge) {
        return edge.label().equals(EdgeLabels$.MODULE$.PARAMETER());
    }

    public static final /* synthetic */ boolean $anonfun$validateParametersCount$1(FunctionTypeParameter x$20) {
        return !x$20.optional();
    }

    public static final /* synthetic */ boolean $anonfun$resolveReturnType$8(WeaveType x$26) {
        return x$26 instanceof DynamicReturnType;
    }

    private FunctionCallNodeResolver$() {
        MODULE$ = this;
        WeaveTypeResolver.$init$(this);
    }
}

