/*
 * Decompiled with CFR 0.152.
 */
package org.mule.weave.v2.utils;

import java.io.Serializable;
import org.mule.weave.v2.codegen.CodeWriter;
import org.mule.weave.v2.codegen.StringCodeWriter;
import org.mule.weave.v2.parser.ast.QName;
import org.mule.weave.v2.ts.AnyType;
import org.mule.weave.v2.ts.ArrayType;
import org.mule.weave.v2.ts.BinaryType;
import org.mule.weave.v2.ts.BooleanType;
import org.mule.weave.v2.ts.DateTimeType;
import org.mule.weave.v2.ts.DynamicReturnType;
import org.mule.weave.v2.ts.FunctionType;
import org.mule.weave.v2.ts.FunctionTypeHelper$;
import org.mule.weave.v2.ts.FunctionTypeParameter;
import org.mule.weave.v2.ts.IntersectionType;
import org.mule.weave.v2.ts.KeyType;
import org.mule.weave.v2.ts.KeyValuePairType;
import org.mule.weave.v2.ts.LocalDateTimeType;
import org.mule.weave.v2.ts.LocalDateType;
import org.mule.weave.v2.ts.LocalTimeType;
import org.mule.weave.v2.ts.NameType;
import org.mule.weave.v2.ts.NameValuePairType;
import org.mule.weave.v2.ts.NamespaceType;
import org.mule.weave.v2.ts.NothingType;
import org.mule.weave.v2.ts.NullType;
import org.mule.weave.v2.ts.NumberType;
import org.mule.weave.v2.ts.ObjectType;
import org.mule.weave.v2.ts.PeriodType;
import org.mule.weave.v2.ts.RangeType;
import org.mule.weave.v2.ts.RecursionDetector;
import org.mule.weave.v2.ts.RecursionDetector$;
import org.mule.weave.v2.ts.ReferenceType;
import org.mule.weave.v2.ts.RegexType;
import org.mule.weave.v2.ts.StringType;
import org.mule.weave.v2.ts.TimeType;
import org.mule.weave.v2.ts.TimeZoneType;
import org.mule.weave.v2.ts.TypeParameter;
import org.mule.weave.v2.ts.TypeType;
import org.mule.weave.v2.ts.UnionType;
import org.mule.weave.v2.ts.WeaveType;
import org.mule.weave.v2.ts.WeaveTypeAnnotation;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;

public final class WeaveTypeEmitter$ {
    public static WeaveTypeEmitter$ MODULE$;

    static {
        new WeaveTypeEmitter$();
    }

    public String toString(WeaveType wtype, boolean prettyPrint) {
        StringCodeWriter builder = new StringCodeWriter();
        return this.generate(wtype, builder, prettyPrint, RecursionDetector$.MODULE$.apply((Function2 & Serializable & scala.Serializable)(id, x$1) -> builder.print((String)id).toString()));
    }

    public boolean toString$default$2() {
        return false;
    }

    private String generate(WeaveType wtype, StringCodeWriter builder, boolean prettyPrint, RecursionDetector<String> recursionDetector) {
        Object object;
        Object object2;
        WeaveType weaveType = wtype;
        if (weaveType instanceof ObjectType) {
            CodeWriter codeWriter;
            ObjectType objectType = (ObjectType)weaveType;
            Seq<KeyValuePairType> properties = objectType.properties();
            if (properties.isEmpty()) {
                codeWriter = builder.print("Object");
            } else {
                Object object3;
                builder.print("{");
                builder.indent();
                ((IterableLike)properties.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)indexProp -> {
                    Object object;
                    Object object2 = indexProp._2$mcI$sp() > 0 ? builder.printSpace(",") : BoxedUnit.UNIT;
                    if (prettyPrint) {
                        builder.println();
                        object = builder.printIndent();
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    return this.generate((WeaveType)indexProp._1(), builder, prettyPrint, recursionDetector);
                });
                builder.dedent();
                if (prettyPrint) {
                    builder.println();
                    object3 = builder.printIndent();
                } else {
                    object3 = BoxedUnit.UNIT;
                }
                codeWriter = builder.print("}");
            }
            object2 = codeWriter;
        } else if (weaveType instanceof KeyValuePairType) {
            KeyValuePairType keyValuePairType = (KeyValuePairType)weaveType;
            WeaveType key = keyValuePairType.key();
            WeaveType value = keyValuePairType.value();
            boolean optional = keyValuePairType.optional();
            this.generate(key, builder, prettyPrint, recursionDetector);
            Object object4 = optional ? builder.print("?") : BoxedUnit.UNIT;
            builder.printSpace(":");
            object2 = this.generate(value, builder, prettyPrint, recursionDetector);
        } else if (weaveType instanceof KeyType) {
            Object object5;
            KeyType keyType = (KeyType)weaveType;
            WeaveType name = keyType.name();
            Seq<NameValuePairType> attrs = keyType.attrs();
            this.generate(name, builder, prettyPrint, recursionDetector);
            if (attrs.nonEmpty()) {
                builder.print(" @(");
                ((IterableLike)attrs.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                    Object object = attr._2$mcI$sp() > 0 ? builder.printSpace(",") : BoxedUnit.UNIT;
                    return this.generate((WeaveType)attr._1(), builder, prettyPrint, recursionDetector);
                });
                object5 = builder.print(")");
            } else {
                object5 = BoxedUnit.UNIT;
            }
            object2 = object5;
        } else if (weaveType instanceof NameValuePairType) {
            NameValuePairType nameValuePairType = (NameValuePairType)weaveType;
            WeaveType name = nameValuePairType.name();
            WeaveType value = nameValuePairType.value();
            boolean optional = nameValuePairType.optional();
            this.generate(name, builder, prettyPrint, recursionDetector);
            Object object6 = optional ? builder.print("?") : BoxedUnit.UNIT;
            builder.print(": ");
            object2 = this.generate(value, builder, prettyPrint, recursionDetector);
        } else if (weaveType instanceof NameType) {
            CodeWriter codeWriter;
            NameType nameType = (NameType)weaveType;
            Option<QName> name = nameType.value();
            Option<QName> option = name;
            if (option instanceof Some) {
                Object object7;
                Some some = (Some)option;
                QName qName = (QName)some.value();
                if (qName.ns().isDefined()) {
                    builder.print((String)qName.ns().get());
                    object7 = builder.print("#");
                } else {
                    object7 = BoxedUnit.UNIT;
                }
                codeWriter = builder.print(qName.name());
            } else if (None$.MODULE$.equals(option)) {
                codeWriter = builder.print("Name");
            } else {
                throw new MatchError(option);
            }
            object2 = codeWriter;
        } else if (weaveType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)weaveType;
            WeaveType of = arrayType.of();
            builder.print("Array<");
            this.generate(of, builder, prettyPrint, recursionDetector);
            object2 = builder.print(">");
        } else if (weaveType instanceof UnionType) {
            UnionType unionType = (UnionType)weaveType;
            Seq<WeaveType> of = unionType.of();
            ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                Object object = item._2$mcI$sp() > 0 ? builder.print(" | ") : BoxedUnit.UNIT;
                return this.generate((WeaveType)item._1(), builder, prettyPrint, recursionDetector);
            });
            object2 = BoxedUnit.UNIT;
        } else if (weaveType instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)weaveType;
            Seq<WeaveType> of = intersectionType.of();
            ((IterableLike)of.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                Object object = item._2$mcI$sp() > 0 ? builder.print(" & ") : BoxedUnit.UNIT;
                return this.generate((WeaveType)item._1(), builder, prettyPrint, recursionDetector);
            });
            object2 = BoxedUnit.UNIT;
        } else if (weaveType instanceof StringType) {
            object2 = builder.print("String");
        } else if (weaveType instanceof AnyType) {
            object2 = builder.print("Any");
        } else if (weaveType instanceof BooleanType) {
            object2 = builder.print("Boolean");
        } else if (weaveType instanceof NumberType) {
            object2 = builder.print("Number");
        } else if (weaveType instanceof RangeType) {
            object2 = builder.print("Range");
        } else if (weaveType instanceof RegexType) {
            object2 = builder.print("Regex");
        } else if (weaveType instanceof NullType) {
            object2 = builder.print("Null");
        } else if (weaveType instanceof DateTimeType) {
            object2 = builder.print("DateTime");
        } else if (weaveType instanceof LocalDateTimeType) {
            object2 = builder.print("LocalDateTime");
        } else if (weaveType instanceof LocalDateType) {
            object2 = builder.print("LocalDate");
        } else if (weaveType instanceof LocalTimeType) {
            object2 = builder.print("LocalTime");
        } else if (weaveType instanceof TimeType) {
            object2 = builder.print("Time");
        } else if (weaveType instanceof TimeZoneType) {
            object2 = builder.print("TimeZone");
        } else if (weaveType instanceof PeriodType) {
            object2 = builder.print("Period");
        } else if (weaveType instanceof BinaryType) {
            object2 = builder.print("Binary");
        } else if (weaveType instanceof TypeParameter) {
            Object object8;
            TypeParameter typeParameter = (TypeParameter)weaveType;
            String name = typeParameter.name();
            Option<WeaveType> bt = typeParameter.baseType();
            builder.print(name);
            if (bt.isDefined()) {
                builder.print(" is ");
                object8 = this.generate((WeaveType)bt.get(), builder, prettyPrint, recursionDetector);
            } else {
                object8 = BoxedUnit.UNIT;
            }
            object2 = object8;
        } else if (weaveType instanceof FunctionType) {
            FunctionType functionType = (FunctionType)weaveType;
            Seq<FunctionTypeParameter> args = functionType.params();
            WeaveType returnType = functionType.returnType();
            builder.print("(");
            ((IterableLike)args.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)item -> {
                Object object;
                Object object2 = item._2$mcI$sp() > 0 ? builder.print(", ") : BoxedUnit.UNIT;
                builder.print(((FunctionTypeParameter)item._1()).name());
                if (!FunctionTypeHelper$.MODULE$.isDynamicTypeParameter(((FunctionTypeParameter)item._1()).wtype())) {
                    builder.printSpace(":");
                    object = this.generate(((FunctionTypeParameter)item._1()).wtype(), builder, prettyPrint, recursionDetector);
                } else {
                    object = BoxedUnit.UNIT;
                }
                return object;
            });
            builder.printSpace(")");
            builder.printSpace("=>");
            object2 = this.generate(returnType, builder, prettyPrint, recursionDetector);
        } else if (weaveType instanceof TypeType) {
            TypeType typeType = (TypeType)weaveType;
            WeaveType t = typeType.t();
            builder.print("Type<");
            this.generate(t, builder, prettyPrint, recursionDetector);
            object2 = builder.print(">");
        } else if (weaveType instanceof NothingType) {
            object2 = builder.print("Nothing");
        } else if (weaveType instanceof NamespaceType) {
            object2 = builder.print("Namespace");
        } else if (weaveType instanceof DynamicReturnType) {
            object2 = builder.print(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"?"})).s((Seq)Nil$.MODULE$));
        } else if (weaveType instanceof ReferenceType) {
            ReferenceType referenceType = (ReferenceType)weaveType;
            object2 = prettyPrint ? builder.println(referenceType.refName()) : recursionDetector.resolve(referenceType, (Function1<WeaveType, String>)(Function1 & Serializable & scala.Serializable)referencedType -> this.generate((WeaveType)referencedType, builder, prettyPrint, recursionDetector));
        } else {
            object2 = builder.print(wtype.getClass().getSimpleName());
        }
        if (!FunctionTypeHelper$.MODULE$.isDynamicTypeParameter(wtype) && wtype.annotations().nonEmpty()) {
            builder.printSpace();
            builder.print("{");
            builder.printForeachWithSeparator(",\n", wtype.annotations(), (Function1 & Serializable & scala.Serializable)annotation -> {
                WeaveTypeEmitter$.$anonfun$generate$7(builder, annotation);
                return BoxedUnit.UNIT;
            });
            object = builder.print("}");
        } else {
            object = BoxedUnit.UNIT;
        }
        return builder.codeContent();
    }

    public boolean isImplicitParameter(String variable) {
        return variable.matches("\\$+");
    }

    public CodeWriter printQName(StringCodeWriter builder, QName name) {
        return builder.print(name.name());
    }

    public static final /* synthetic */ void $anonfun$generate$7(StringCodeWriter builder$2, WeaveTypeAnnotation annotation) {
        builder$2.printQuoted(annotation.name()).printSpace(":").printQuoted(annotation.value().toString());
    }

    private WeaveTypeEmitter$() {
        MODULE$ = this;
    }
}

