/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.persistence.MetadataSerializingException;
import org.mule.metadata.persistence.MetadataTypeConstants;
import org.mule.metadata.persistence.NullObjectTypeReferenceHandler;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.deserializer.MetadataTypeDeserializerProvider;
import org.mule.metadata.persistence.deserializer.TypeDeserializer;

public class JsonMetadataTypeLoader
implements TypeLoader {
    private static final String MISSING_METADATA_FORMAT_ATTRIBUTE = "MetadataFormat object is malformed. '%s' property is required.";
    private static final String UNSUPPORTED_METADATA_TYPE_FOUND = "Unsupported MetadataType '%s' found.";
    private final MetadataTypeDeserializerProvider typeDeserializerProvider = new MetadataTypeDeserializerProvider();
    private final ObjectTypeReferenceHandler referenceHandler;
    private Stack<TypeBuilder> typeBuilderStack;
    private Stack<MetadataFormat> metadataFormatStack;

    public JsonMetadataTypeLoader() {
        this(new NullObjectTypeReferenceHandler());
    }

    public JsonMetadataTypeLoader(ObjectTypeReferenceHandler referenceHandler) {
        this.referenceHandler = referenceHandler;
    }

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        try {
            JsonElement metadataType = new JsonParser().parse(typeIdentifier);
            return this.load(metadataType);
        }
        catch (JsonSyntaxException e) {
            throw new MetadataSerializingException("Error occurred deserializating the MetadataType", (Exception)((Object)e));
        }
    }

    public Optional<MetadataType> load(JsonElement jsonElement) {
        try {
            this.typeBuilderStack = new Stack();
            this.metadataFormatStack = new Stack();
            JsonObject metadataType = jsonElement.getAsJsonObject();
            JsonElement formatElement = metadataType.get("format");
            MetadataFormat format = this.buildMetadataFormat(formatElement);
            this.metadataFormatStack.push(format);
            BaseTypeBuilder baseTypeBuilder = BaseTypeBuilder.create(format);
            TypeBuilder typeBuilder = this.buildType((JsonElement)metadataType, baseTypeBuilder);
            Object build = typeBuilder.build();
            return Optional.of(build);
        }
        catch (Exception e) {
            throw new MetadataSerializingException("Error occurred deserializating the MetadataType", e);
        }
    }

    public TypeBuilder buildType(JsonElement jsonElement, BaseTypeBuilder baseBuilder) {
        TypeBuilder typeBuilder;
        this.typeBuilderStack.push(baseBuilder);
        if (jsonElement.isJsonObject()) {
            JsonObject typeObject = jsonElement.getAsJsonObject();
            MetadataFormat currentMetadataFormat = this.updateMetadataFormat(typeObject, baseBuilder, this.metadataFormatStack.peek());
            this.metadataFormatStack.push(currentMetadataFormat);
            String type = typeObject.get("type").getAsString();
            Optional<TypeDeserializer> typeDeserializer = this.typeDeserializerProvider.get(type);
            if (typeDeserializer.isPresent()) {
                typeBuilder = typeDeserializer.get().buildType(typeObject, baseBuilder, this);
            } else {
                typeBuilder = this.referenceHandler.readReference(type).orElse(null);
                if (typeBuilder == null) {
                    throw new MetadataSerializingException(String.format(UNSUPPORTED_METADATA_TYPE_FOUND, type));
                }
            }
            this.metadataFormatStack.pop();
        } else {
            String typeReference = jsonElement.getAsString();
            if (typeReference.startsWith("#")) {
                typeBuilder = (TypeBuilder)this.typeBuilderStack.get(this.getTypeIndex(typeReference));
            } else {
                throw new MetadataSerializingException(String.format(UNSUPPORTED_METADATA_TYPE_FOUND, typeReference));
            }
        }
        this.typeBuilderStack.pop();
        return typeBuilder;
    }

    private int getTypeIndex(String typeReference) {
        return this.typeBuilderStack.size() - typeReference.split("/").length - 1;
    }

    private MetadataFormat updateMetadataFormat(JsonObject jsonElement, BaseTypeBuilder baseBuilder, MetadataFormat currentFormat) {
        MetadataFormat metadataFormat = currentFormat;
        JsonObject type = jsonElement.getAsJsonObject();
        if (type.has("format")) {
            JsonElement formatJsonElement = type.get("format");
            metadataFormat = this.buildMetadataFormat(formatJsonElement);
        }
        baseBuilder.withFormat(metadataFormat);
        return metadataFormat;
    }

    private MetadataFormat buildMetadataFormat(JsonElement formatElement) {
        MetadataFormat metadataFormat;
        if (formatElement.isJsonObject()) {
            ArrayList<String> validMimeTypesList = new ArrayList<String>();
            String label = null;
            JsonObject formatObject = formatElement.getAsJsonObject();
            if (!formatObject.has("id")) {
                throw new MetadataSerializingException(String.format(MISSING_METADATA_FORMAT_ATTRIBUTE, "id"));
            }
            String id = formatObject.get("id").getAsString();
            if (formatObject.has("label")) {
                label = formatObject.get("label").getAsString();
            }
            for (JsonElement validMimeTypes : formatObject.get("validMimeTypes").getAsJsonArray()) {
                validMimeTypesList.add(validMimeTypes.getAsString());
            }
            metadataFormat = new MetadataFormat(label, id, validMimeTypesList.toArray(new String[validMimeTypesList.size()]));
        } else {
            String formatId = formatElement.getAsString();
            int formatIndex = MetadataTypeConstants.commonMetadataFormats.indexOf(new MetadataFormat("label", formatId, new String[0]));
            metadataFormat = MetadataTypeConstants.commonMetadataFormats.get(formatIndex);
        }
        return metadataFormat;
    }
}

