/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.artifact.classloader;

import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Hooks;

public class ErrorHooksConfiguration {
    private static Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void logError(String message) {
        if (logger == null) {
            Class<ErrorHooksConfiguration> clazz = ErrorHooksConfiguration.class;
            // MONITORENTER : org.mule.module.artifact.classloader.ErrorHooksConfiguration.class
            if (logger == null) {
                logger = LoggerFactory.getLogger(ErrorHooksConfiguration.class);
            }
            // MONITOREXIT : clazz
        }
        logger.error(message);
    }

    static {
        Hooks.onOperatorError((throwable, signal) -> {
            throwable = Exceptions.unwrap(throwable);
            if (signal instanceof InternalEvent) {
                return throwable instanceof MessagingException ? throwable : new MessagingException((InternalEvent)signal, ExceptionUtils.getRootCauseException(throwable));
            }
            return throwable;
        });
        Hooks.onErrorDropped(error -> ErrorHooksConfiguration.logError("ERROR DROPPED UNEXPECTEDLY " + error));
        Hooks.onNextDropped(event -> ErrorHooksConfiguration.logError("EVENT DROPPED UNEXPECTEDLY " + event));
    }
}

