/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.stereotype;

import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Preconditions;

public final class ImmutableStereotypeModel
implements StereotypeModel {
    private String type;
    private String namespace;
    private StereotypeModel parent;

    public ImmutableStereotypeModel() {
    }

    ImmutableStereotypeModel(String name, String namespace, StereotypeModel parent) {
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)name), "An stereotype name is required");
        Preconditions.checkArgument(StringUtils.isNotBlank((CharSequence)namespace), "An stereotype namespace is required");
        this.type = name;
        this.namespace = namespace;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.type;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Optional<StereotypeModel> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableStereotypeModel)) {
            return false;
        }
        ImmutableStereotypeModel that = (ImmutableStereotypeModel)o;
        return this.type.equals(that.type) && this.namespace.equals(that.namespace) && this.parent != null ? this.parent.equals(that.parent) : that.parent == null;
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.namespace.hashCode();
        result = 31 * result + (this.parent != null ? this.parent.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.namespace + ":" + this.type + (this.parent == null ? "" : "(" + this.parent.toString() + ")");
    }
}

