/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.builders;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.FilenameUtils;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesMuleConfigurationFactory {
    private static Logger logger = LoggerFactory.getLogger(PropertiesMuleConfigurationFactory.class);
    private Properties properties;

    public static String getMuleAppConfiguration(String muleConfig) {
        String directory = FilenameUtils.getFullPath((String)muleConfig);
        String muleAppConfiguration = directory + "mule-config.xml";
        return muleAppConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesMuleConfigurationFactory(String muleAppConfiguration) {
        URL muleAppURL = ClassUtils.getResource(muleAppConfiguration, this.getClass());
        if (muleAppURL != null) {
            this.properties = new Properties();
            InputStream inputStream = null;
            try {
                inputStream = muleAppURL.openStream();
                this.properties.load(inputStream);
            }
            catch (IOException e) {
                logger.debug("Unable to read properties", (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    public DefaultMuleConfiguration createConfiguration() {
        DefaultMuleConfiguration configuration = new DefaultMuleConfiguration();
        if (this.properties != null) {
            this.initializeFromProperties(configuration);
        }
        return configuration;
    }

    private void initializeFromProperties(MuleConfiguration configuration) {
        PropertiesMuleConfigurationFactory.initializeFromProperties(configuration, this.properties);
    }

    public static void initializeFromProperties(MuleConfiguration configuration, Map properties) {
        Iterator iterator = properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entryObject;
            Map.Entry entry = entryObject = iterator.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("sys.")) {
                String systemProperty = key.substring(4);
                System.setProperty(systemProperty, value);
                continue;
            }
            if (!key.startsWith("mule.config.")) continue;
            String configProperty = key.substring(12);
            try {
                BeanUtils.setProperty((Object)configuration, (String)configProperty, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("Cannot set configuration property", (Throwable)e);
            }
        }
    }
}

