/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.model.config;

import java.util.Optional;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.config.spring.internal.dsl.model.config.ConfigurationPropertiesResolver;
import org.mule.runtime.config.spring.internal.dsl.model.config.PropertyNotFoundException;

public class PropertiesResolverConfigurationProperties
implements ConfigurationProperties {
    private final ConfigurationPropertiesResolver configurationPropertiesResolver;

    public PropertiesResolverConfigurationProperties(ConfigurationPropertiesResolver configurationPropertiesResolver) {
        this.configurationPropertiesResolver = configurationPropertiesResolver;
    }

    public Optional<Object> resolveProperty(String propertyKey) {
        try {
            return Optional.ofNullable(this.configurationPropertiesResolver.resolvePlaceholderKeyValue(propertyKey));
        }
        catch (PropertyNotFoundException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Boolean> resolveBooleanProperty(String property) {
        return this.resolveProperty(property).flatMap(value -> {
            if (value instanceof Boolean) {
                return Optional.of((Boolean)value);
            }
            if (value instanceof String) {
                return Optional.of(Boolean.valueOf((String)value));
            }
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Property %s with value %s cannot be converted to boolean", property, value)));
        });
    }

    @Override
    public Optional<String> resolveStringProperty(String property) {
        return this.resolveProperty(property).map(value -> value instanceof String ? (String)value : value.toString());
    }

    public ConfigurationPropertiesResolver getConfigurationPropertiesResolver() {
        return this.configurationPropertiesResolver;
    }
}

