/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.dsl.spring;

import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.config.spring.internal.dsl.model.SpringComponentModel;
import org.mule.runtime.config.spring.internal.dsl.processor.ObjectTypeVisitor;
import org.mule.runtime.config.spring.internal.dsl.spring.BeanDefinitionCreator;
import org.mule.runtime.config.spring.internal.dsl.spring.CreateBeanDefinitionRequest;
import org.mule.runtime.config.spring.internal.dsl.spring.MapFactoryBean;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;

class MapBeanDefinitionCreator
extends BeanDefinitionCreator {
    MapBeanDefinitionCreator() {
    }

    @Override
    boolean handleRequest(CreateBeanDefinitionRequest createBeanDefinitionRequest) {
        SpringComponentModel componentModel = createBeanDefinitionRequest.getComponentModel();
        ObjectTypeVisitor objectTypeVisitor = new ObjectTypeVisitor(componentModel);
        ComponentBuildingDefinition componentBuildingDefinition = createBeanDefinitionRequest.getComponentBuildingDefinition();
        componentBuildingDefinition.getTypeDefinition().visit(objectTypeVisitor);
        Class<?> type = objectTypeVisitor.getType();
        if (Map.class.isAssignableFrom(type) && componentBuildingDefinition.getObjectFactoryType() == null) {
            ManagedList managedList = componentModel.getInnerComponents().stream().map(c -> ((SpringComponentModel)c).getBeanDefinition()).collect(Collectors.toCollection(ManagedList::new));
            componentModel.setBeanDefinition((BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition(MapFactoryBean.class).addConstructorArgValue((Object)managedList).addConstructorArgValue(type).getBeanDefinition());
            return true;
        }
        return false;
    }
}

