/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.editors;

import java.beans.PropertyEditor;
import java.io.InputStream;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.mule.runtime.config.spring.internal.editors.DatePropertyEditor;
import org.mule.runtime.config.spring.internal.editors.MessageExchangePatternPropertyEditor;
import org.mule.runtime.core.api.MessageExchangePattern;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;

public class MulePropertyEditorRegistrar
implements PropertyEditorRegistrar,
MuleContextAware {
    private MuleContext muleContext;
    private Map<Class<?>, Class<PropertyEditor>> customPropertyEditorsCache;
    private static final String CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME = "META-INF/mule.custom-property-editors";

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        registry.registerCustomEditor(MessageExchangePattern.class, (PropertyEditor)new MessageExchangePatternPropertyEditor());
        registry.registerCustomEditor(Date.class, (PropertyEditor)new DatePropertyEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd hh:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), true));
        if (this.customPropertyEditorsCache == null) {
            this.discoverCustomPropertyEditor();
        }
        for (Map.Entry<Class<?>, Class<PropertyEditor>> entry : this.customPropertyEditorsCache.entrySet()) {
            try {
                PropertyEditor customEditor = ClassUtils.instantiateClass(entry.getValue(), new Object[0]);
                if (customEditor instanceof MuleContextAware) {
                    ((MuleContextAware)((Object)customEditor)).setMuleContext(this.muleContext);
                }
                registry.registerCustomEditor(entry.getKey(), customEditor);
            }
            catch (Exception e) {
                throw new IllegalStateException("Error loading custom property editors", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverCustomPropertyEditor() {
        this.customPropertyEditorsCache = new HashMap();
        try {
            Enumeration<URL> urls = ClassUtils.getResources(CUSTOM_PROPERTY_EDITOR_RESOURCE_NAME, this.getClass());
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                Properties props = new Properties();
                InputStream stream = url.openStream();
                try {
                    props.load(stream);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        String target = (String)entry.getKey();
                        String editor = (String)entry.getValue();
                        Class requiredType = ClassUtils.loadClass(target, this.getClass());
                        Class propertyEditorClass = ClassUtils.loadClass(editor, this.getClass());
                        this.customPropertyEditorsCache.put(requiredType, propertyEditorClass);
                    }
                }
                finally {
                    IOUtils.closeQuietly(stream);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error loading custom property editors", e);
        }
    }
}

