/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.spring.internal.factories;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.config.spring.internal.MuleArtifactContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AnnotatedProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.dsl.api.component.AbstractAnnotatedObjectFactory;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class FlowRefFactoryBean
extends AbstractAnnotatedObjectFactory<Processor>
implements ApplicationContextAware,
MuleContextAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowRefFactoryBean.class);
    private String refName;
    private ApplicationContext applicationContext;
    private MuleContext muleContext;

    public void setName(String name) {
        this.refName = name;
    }

    @Override
    public Processor doGetObject() throws Exception {
        if (this.refName.isEmpty()) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull("flow reference is empty"));
        }
        return new FlowRefMessageProcessor();
    }

    protected Processor getReferencedFlow(String name) throws MuleException {
        if (name == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        Processor referencedFlow = this.getReferencedProcessor(name);
        if (referencedFlow == null) {
            throw new MuleRuntimeException(CoreMessages.objectIsNull(name));
        }
        if (!(referencedFlow instanceof Flow)) {
            if (referencedFlow instanceof AnnotatedObject) {
                HashMap<QName, Object> annotations = new HashMap<QName, Object>(((AnnotatedObject)((Object)referencedFlow)).getAnnotations());
                annotations.put(ROOT_CONTAINER_NAME_KEY, this.getRootContainerName());
                ((AnnotatedObject)((Object)referencedFlow)).setAnnotations(annotations);
            }
            if (referencedFlow instanceof Initialisable) {
                this.prepareProcessor(referencedFlow);
                if (referencedFlow instanceof MessageProcessorChain) {
                    for (Processor processor : ((MessageProcessorChain)referencedFlow).getMessageProcessors()) {
                        this.prepareProcessor(processor);
                    }
                }
                LifecycleUtils.initialiseIfNeeded(referencedFlow);
            }
            LifecycleUtils.startIfNeeded(referencedFlow);
        }
        return referencedFlow;
    }

    private Processor getReferencedProcessor(String name) {
        MuleArtifactContext muleArtifactContext;
        if (this.applicationContext instanceof MuleArtifactContext && (muleArtifactContext = (MuleArtifactContext)this.applicationContext).getBeanFactory().getBeanDefinition(name).isPrototype()) {
            muleArtifactContext.getPrototypeBeanWithRootContainer(name, this.getRootContainerName());
        }
        return (Processor)this.applicationContext.getBean(name);
    }

    private void prepareProcessor(Processor p) {
        if (p instanceof MuleContextAware) {
            ((MuleContextAware)((Object)p)).setMuleContext(this.muleContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    private class FlowRefMessageProcessor
    extends AbstractAnnotatedObject
    implements AnnotatedProcessor,
    Stoppable,
    Disposable {
        private LoadingCache<String, Processor> cache;
        private boolean isExpression;

        public FlowRefMessageProcessor() {
            this.cache = CacheBuilder.newBuilder().maximumSize(20L).build((CacheLoader)new CacheLoader<String, Processor>(){

                public Processor load(String key) throws Exception {
                    return FlowRefFactoryBean.this.getReferencedFlow(key);
                }
            });
            this.isExpression = FlowRefFactoryBean.this.muleContext.getExpressionManager().isExpression(FlowRefFactoryBean.this.refName);
        }

        @Override
        public InternalEvent process(InternalEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
            return Flux.from(publisher).flatMap(event -> {
                Processor referencedProcessor;
                try {
                    referencedProcessor = this.resolveReferencedProcessor((InternalEvent)event);
                }
                catch (MuleException e) {
                    return Flux.error((Throwable)e);
                }
                if (referencedProcessor instanceof Flow) {
                    return Flux.just((Object)event).flatMap(request -> Mono.from(MessageProcessors.processWithChildContext(request, referencedProcessor, Optional.ofNullable(FlowRefFactoryBean.this.getLocation()), ((Flow)referencedProcessor).getExceptionListener())));
                }
                return Flux.just((Object)event).transform((Function)referencedProcessor);
            });
        }

        protected Processor resolveReferencedProcessor(InternalEvent event) throws MuleException {
            String flowName = this.isExpression ? FlowRefFactoryBean.this.muleContext.getExpressionManager().parse(FlowRefFactoryBean.this.refName, event, this.getLocation()) : FlowRefFactoryBean.this.refName;
            try {
                return (Processor)this.cache.getUnchecked((Object)flowName);
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof MuleRuntimeException) {
                    throw (MuleRuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public ComponentLocation getLocation() {
            return FlowRefFactoryBean.this.getLocation();
        }

        @Override
        public void stop() throws MuleException {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.stopIfNeeded(p);
            }
        }

        @Override
        public void dispose() {
            for (Processor p : this.cache.asMap().values()) {
                if (p instanceof Flow) continue;
                LifecycleUtils.disposeIfNeeded(p, LOGGER);
            }
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

