/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.context.notification;

import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.Processor;

public class EnrichedNotificationInfo {
    private String id;
    private String correlationId;
    private Message message;
    private Optional<Error> error;
    private Event event;
    private Object component;
    private Exception exception;
    private Map<String, TypedValue> variables;
    private String originatingFlowName;
    private FlowCallStack flowCallStack;
    InternalEvent internalEvent;

    public static EnrichedNotificationInfo createInfo(InternalEvent event, Exception e, Object component) {
        if (event != null) {
            if (component == null && e != null) {
                component = EnrichedNotificationInfo.componentFromException(e);
            }
            EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(event, component, e, event.getFlowCallStack());
            notificationInfo.event = event;
            return notificationInfo;
        }
        if (e != null) {
            if (e instanceof MessagingException) {
                MessagingException messagingException = (MessagingException)e;
                if (messagingException.getEvent() != null) {
                    return EnrichedNotificationInfo.createInfo(messagingException.getEvent(), e, EnrichedNotificationInfo.componentFromException(e));
                }
            } else {
                EnrichedNotificationInfo notificationInfo = new EnrichedNotificationInfo(null, null, e, null);
                notificationInfo.event = event;
                return notificationInfo;
            }
        }
        throw new RuntimeException("Neither event or exception present");
    }

    private static AnnotatedObject componentFromException(Exception e) {
        MessagingException messagingException;
        Processor messageProcessor;
        if (e instanceof MessagingException && (messageProcessor = (messagingException = (MessagingException)e).getFailingMessageProcessor()) instanceof AnnotatedObject) {
            return (AnnotatedObject)((Object)messageProcessor);
        }
        return null;
    }

    public EnrichedNotificationInfo(InternalEvent event, Object component, Exception exception, FlowCallStack flowCallStack) {
        this.event = event;
        this.component = component;
        this.exception = exception;
        this.flowCallStack = flowCallStack;
    }

    public Event getEvent() {
        return this.event;
    }

    public AnnotatedObject getComponent() {
        if (this.component != null && this.component instanceof AnnotatedObject) {
            return (AnnotatedObject)this.component;
        }
        return null;
    }

    public Exception getException() {
        return this.exception;
    }

    public FlowCallStack getFlowCallStack() {
        return this.flowCallStack;
    }
}

