/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.extension;

import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.XmlDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConstructDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NestedRouteDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OptionalParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.api.meta.model.error.ErrorModelBuilder;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.source.SchedulingStrategy;
import org.mule.runtime.core.api.source.polling.CronScheduler;
import org.mule.runtime.core.api.source.polling.FixedFrequencyScheduler;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.internal.dsl.DslConstants;

class MuleExtensionModelDeclarer {
    MuleExtensionModelDeclarer() {
    }

    ExtensionDeclarer createExtensionModel() {
        ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionModelDeclarer.class.getClassLoader());
        ExtensionDeclarer extensionDeclarer = new ExtensionDeclarer().named("Mule Core").describedAs("Mule Runtime and Integration Platform: Core components").onVersion(MuleExtensionModelProvider.MULE_VERSION).fromVendor("MuleSoft, Inc.").withCategory(Category.COMMUNITY).withMinMuleVersion(new MuleVersion(MuleExtensionModelProvider.MULE_VERSION)).withXmlDsl(XmlDslModel.builder().setPrefix("mule").setNamespace(DslConstants.CORE_NAMESPACE).setSchemaVersion("4.0.0-SNAPSHOT").setXsdFileName("mule.xsd").setSchemaLocation("http://www.mulesoft.org/schema/mule/core/current/mule.xsd").build());
        this.declareFlow(extensionDeclarer, typeLoader);
        this.declareForEach(extensionDeclarer, typeLoader);
        this.declareChoice(extensionDeclarer, typeLoader);
        this.declareErrorHandler(extensionDeclarer, typeLoader);
        this.declareTry(extensionDeclarer, typeLoader);
        this.declareAsync(extensionDeclarer, typeLoader);
        this.declareScatterGather(extensionDeclarer, typeLoader);
        this.declareConfiguration(extensionDeclarer, typeLoader);
        this.declareFlowRef(extensionDeclarer, typeLoader);
        this.declareIdempotentValidator(extensionDeclarer, typeLoader);
        this.declareLogger(extensionDeclarer, typeLoader);
        this.declareScheduler(extensionDeclarer, typeLoader);
        this.declareErrors(extensionDeclarer);
        return extensionDeclarer;
    }

    private void declareScheduler(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        SourceDeclarer scheduler = (SourceDeclarer)extensionDeclarer.withMessageSource("scheduler").hasResponse(false).describedAs("Source that schedules periodic execution of a flow.");
        scheduler.withOutput().ofType(typeLoader.load((Type)((Object)Object.class)));
        scheduler.withOutputAttributes().ofType(typeLoader.load((Type)((Object)Object.class)));
        MetadataType baseSchedulingStrategy = typeLoader.load((Type)((Object)SchedulingStrategy.class));
        ((ParameterDeclarer)scheduler.onDefaultParameterGroup().withRequiredParameter("schedulingStrategy").ofType(baseSchedulingStrategy)).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        MetadataType fixedFrequencyScheduler = typeLoader.load((Type)((Object)FixedFrequencyScheduler.class));
        MetadataType cronScheduler = typeLoader.load((Type)((Object)CronScheduler.class));
        extensionDeclarer.withSubType(baseSchedulingStrategy, fixedFrequencyScheduler);
        extensionDeclarer.withSubType(baseSchedulingStrategy, cronScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)baseSchedulingStrategy);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)fixedFrequencyScheduler);
        ((ExtensionDeclaration)extensionDeclarer.getDeclaration()).addType((ObjectType)cronScheduler);
    }

    private void declareIdempotentValidator(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer validator = (OperationDeclarer)extensionDeclarer.withOperation("idempotentMessageValidator").describedAs("Ensures that only unique messages are received by a service by checking the unique ID of the incoming message. Note that the ID used can be generated from the message using an expression defined in the 'idExpression' attribute. Otherwise, a 'FILTERED' error is generated.");
        validator.withOutput().ofType(typeLoader.load(Void.TYPE));
        validator.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("idExpression").ofType(typeLoader.load((Type)((Object)String.class)))).defaultingTo("#[id]").withDsl(ParameterDslConfiguration.builder().allowsReferences(false).build())).describedAs("Defines one or more expressions to use when extracting the ID from the message. If this property is not set, '#[id]' will be used by default.");
        ((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("valueExpression").ofType(typeLoader.load((Type)((Object)String.class)))).defaultingTo("#[id]").describedAs("Defines one or more expressions to use when extracting the value from the message.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("objectStore").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The object store where the IDs of the processed events are going to be stored.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)validator.onDefaultParameterGroup().withOptionalParameter("storePrefix").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Defines the prefix of the object store names. This will only be used for the internally built object store.");
        validator.withErrorModel(ErrorModelBuilder.newError("FILTERED", "MULE").withParent(ErrorModelBuilder.newError("ANY", "MULE").build()).build());
    }

    private void declareAsync(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer async = (ConstructDeclarer)extensionDeclarer.withConstruct("async").describedAs("Processes the nested list of message processors asynchronously using a thread pool");
        async.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)async.onDefaultParameterGroup().withOptionalParameter("name").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(typeLoader.load((Type)((Object)String.class)))).describedAs("Name that will be used to name the async scheduler");
    }

    private void declareFlowRef(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer flowRef = (OperationDeclarer)extensionDeclarer.withOperation("flowRef").describedAs("Allows a 'flow' to be referenced such that the message processing will continue in the referenced flow before returning. Message processing in the referenced 'flow' will occur within the context of the referenced flow and will therefore use its exception strategy etc.");
        flowRef.withOutput().ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).anyType().build());
        flowRef.withOutputAttributes().ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).anyType().build());
        ((ParameterDeclarer)((ParameterDeclarer)flowRef.onDefaultParameterGroup().withRequiredParameter("name").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The name of the flow to call");
    }

    private void declareLogger(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        OperationDeclarer logger = (OperationDeclarer)extensionDeclarer.withOperation("logger").describedAs("Performs logging using an expression that determines what should be logged. By default the current messages is logged using the DEBUG level to the 'org.mule.runtime.core.api.processor.LoggerMessageProcessor' category but the level and category can both be configured to suit your needs. message is specified then the current message is used.");
        logger.withOutput().ofType(typeLoader.load(Void.TYPE));
        logger.withOutputAttributes().ofType(typeLoader.load(Void.TYPE));
        ((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("message").ofType(typeLoader.load((Type)((Object)String.class)))).describedAs("Message that will be logged. Embedded expressions can be used to extract value from the current message. If no message is specified then the current message is used.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("level").defaultingTo("DEBUG").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("ERROR", "WARN", "INFO", "DEBUG", "TRACE").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The logging level to be used. Default is DEBUG.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)logger.onDefaultParameterGroup().withOptionalParameter("category").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The log category to be used");
    }

    private void declareForEach(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer forEach = (ConstructDeclarer)extensionDeclarer.withConstruct("foreach").describedAs("The foreach Processor allows iterating over a collection payload, or any collection obtained by an expression, generating a message for each element.");
        forEach.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("collection").ofType(typeLoader.load(new TypeToken<Iterable<Object>>(){}.getType()))).defaultingTo("#[payload]").withExpressionSupport(ExpressionSupport.REQUIRED)).describedAs("An expression to that returns a java collection, object array, map or DOM nodes.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("batchSize").ofType(typeLoader.load((Type)((Object)Integer.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("An expression to that returns a java collection, object array, map or DOM nodes.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("rootMessageVariableName").ofType(typeLoader.load((Type)((Object)String.class)))).defaultingTo("rootMessage").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Property name where the parent message is stored.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("counterVariableName").ofType(typeLoader.load((Type)((Object)String.class)))).defaultingTo("counter").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Property name used to store the number of message being iterated.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)forEach.onDefaultParameterGroup().withOptionalParameter("ignoreErrorType").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("ANY", "REDELIVERY_EXHAUSTED", "TRANSFORMATION", "EXPRESSION", "SECURITY", "CLIENT_SECURITY", "SERVER_SECURITY", "ROUTING", "CONNECTIVITY", "RETRY_EXHAUSTED").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().tabName("Advanced").build())).withDisplayModel(DisplayModel.builder().displayName("Ignore Error Type").build())).describedAs("A comma separated list of error types that should be handled, so that items that cause them when being processed are ignored, rather than propagating the error. This is useful to use validations inside this component.");
    }

    private void declareChoice(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer choice = (ConstructDeclarer)extensionDeclarer.withConstruct("choice").describedAs("Sends the message to the first message processor whose condition has been satisfied. If no conditions were satisfied, sends to the configured default message processor if configured, or throws an exception if not configured.");
        NestedRouteDeclarer when = choice.withRoute("when").withMinOccurs(1);
        ((ParameterDeclarer)when.onDefaultParameterGroup().withRequiredParameter("expression").ofType(typeLoader.load(Boolean.TYPE))).describedAs("The expression to evaluate.");
        choice.withRoute("otherwise").withMaxOccurs(1);
    }

    private void declareFlow(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer flow = (ConstructDeclarer)extensionDeclarer.withConstruct("flow").allowingTopLevelDefinition().withStereotype(MuleExtensionModelProvider.FLOW_STEREOTYPE);
        flow.onDefaultParameterGroup().withOptionalParameter("initialState").defaultingTo("started").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("started", "stopped").build());
        flow.onDefaultParameterGroup().withOptionalParameter("maxConcurrency").ofType(typeLoader.load((Type)((Object)Integer.class)));
        flow.withComponent("source").withAllowedStereotypes(MuleExtensionModelProvider.SOURCE_STEREOTYPE);
        flow.withChain().setRequired(true);
        flow.withComponent("errorHandler").withAllowedStereotypes(MuleExtensionModelProvider.ERROR_HANDLER_STEREOTYPE);
    }

    private void declareScatterGather(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer scatterGather = (ConstructDeclarer)extensionDeclarer.withConstruct("scatterGather").describedAs("Sends the same message to multiple message processors in parallel.");
        scatterGather.withRoute("route").withMinOccurs(2);
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)scatterGather.onDefaultParameterGroup().withOptionalParameter("timeout").ofType(typeLoader.load((Type)((Object)Long.class)))).defaultingTo(0).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Sets a timeout in milliseconds for each route. Values lower or equals than zero means no timeout.");
    }

    private void declareTry(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer tryScope = (ConstructDeclarer)extensionDeclarer.withConstruct("try").describedAs("Processes the nested list of message processors, within a transaction and with it's own error handler if required.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionalAction").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("INDIFFERENT", "ALWAYS_BEGIN", "BEGIN_OR_JOIN").build())).defaultingTo("INDIFFERENT").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).withLayout(LayoutModel.builder().tabName("Transactions").build())).describedAs("The action to take regarding transactions. By default nothing will be done.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)tryScope.onDefaultParameterGroup().withOptionalParameter("transactionType").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("LOCAL", "MULTI", "XA").build())).defaultingTo("LOCAL").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Transaction type supported. Availability will depend on the runtime version, though LOCAL is always available.");
        tryScope.withChain();
        tryScope.withOptionalComponent("errorHandler").withAllowedStereotypes(MuleExtensionModelProvider.ERROR_HANDLER_STEREOTYPE);
    }

    private void declareErrorHandler(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer errorHandler = (ConstructDeclarer)((ConstructDeclarer)extensionDeclarer.withConstruct("errorHandler").withStereotype(MuleExtensionModelProvider.ERROR_HANDLER_STEREOTYPE)).allowingTopLevelDefinition().describedAs("Allows the definition of internal selective handlers. It will route the error to the first handler that matches it. If there's no match, then a default error handler will be executed.");
        NestedRouteDeclarer onErrorContinue = errorHandler.withRoute("onErrorContinue").describedAs("Error handler used to handle exceptions. It will commit any transaction as if the message was consumed successfully.");
        this.declareOnErrorRoute(typeLoader, onErrorContinue);
        NestedRouteDeclarer onErrorPropagate = errorHandler.withRoute("onErrorPropagate").describedAs("Error handler used to propagate errors. It will rollback any transaction and not consume messages.");
        this.declareOnErrorRoute(typeLoader, onErrorPropagate);
    }

    private void declareOnErrorRoute(ClassTypeLoader typeLoader, NestedRouteDeclarer onError) {
        onError.withChain();
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("name").withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).ofType(typeLoader.load((Type)((Object)String.class)))).describedAs("The expression that will be evaluated to determine if this exception strategy should be executed. This should always be a boolean expression.");
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("when").ofType(typeLoader.load((Type)((Object)String.class)))).describedAs("The expression that will be evaluated to determine if this exception strategy should be executed. This should always be a boolean expression.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("type").ofType(BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().id(String.class.getName()).enumOf("ANY", "REDELIVERY_EXHAUSTED", "TRANSFORMATION", "EXPRESSION", "SECURITY", "CLIENT_SECURITY", "SERVER_SECURITY", "ROUTING", "CONNECTIVITY", "RETRY_EXHAUSTED").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The full name of the error type to match against or a comma separated list of full names, to match against any of them.");
        ((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("logException").ofType(typeLoader.load(Boolean.TYPE))).defaultingTo(true).describedAs("Determines whether the handled exception will be logged to its standard logger in the ERROR level before being handled. Default is true.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)onError.onDefaultParameterGroup().withOptionalParameter("enableNotifications").ofType(typeLoader.load(Boolean.TYPE))).defaultingTo(true).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("Determines whether ExceptionNotifications will be fired from this strategy when an exception occurs. Default is true.");
    }

    private void declareErrors(ExtensionDeclarer extensionDeclarer) {
        ErrorModel anyError = ErrorModelBuilder.newError(MuleErrors.ANY.name(), "mule".toUpperCase()).build();
        ErrorModel securityError = ErrorModelBuilder.newError(MuleErrors.SECURITY.name(), "mule".toUpperCase()).build();
        ErrorModel sourceError = ErrorModelBuilder.newError(MuleErrors.SOURCE.name(), "mule".toUpperCase()).build();
        ErrorModel sourceResponseError = ErrorModelBuilder.newError(MuleErrors.SOURCE_RESPONSE.name(), "mule".toUpperCase()).build();
        extensionDeclarer.withErrorModel(anyError);
        extensionDeclarer.withErrorModel(securityError);
        extensionDeclarer.withErrorModel(sourceError);
        extensionDeclarer.withErrorModel(sourceResponseError);
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.EXPRESSION.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.TRANSFORMATION.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.CONNECTIVITY.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.RETRY_EXHAUSTED.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.REDELIVERY_EXHAUSTED.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.ROUTING.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.OVERLOAD.name(), "mule".toUpperCase()).withParent(anyError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.CLIENT_SECURITY.name(), "mule".toUpperCase()).withParent(securityError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.SERVER_SECURITY.name(), "mule".toUpperCase()).withParent(securityError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.SOURCE_ERROR_RESPONSE_GENERATE.name(), "mule".toUpperCase()).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.SOURCE_ERROR_RESPONSE_SEND.name(), "mule".toUpperCase()).withParent(sourceError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.SOURCE_RESPONSE_GENERATE.name(), "mule".toUpperCase()).withParent(sourceResponseError).build());
        extensionDeclarer.withErrorModel(ErrorModelBuilder.newError(MuleErrors.SOURCE_RESPONSE_SEND.name(), "mule".toUpperCase()).withParent(sourceResponseError).build());
    }

    private void declareConfiguration(ExtensionDeclarer extensionDeclarer, ClassTypeLoader typeLoader) {
        ConstructDeclarer configuration = (ConstructDeclarer)extensionDeclarer.withConstruct("configuration").allowingTopLevelDefinition().describedAs("Specifies defaults and general settings for the Mule instance.");
        InfrastructureParameterBuilder.addReconnectionStrategyParameter((ParameterizedDeclaration)configuration.getDeclaration());
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultResponseTimeout").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo("10000").describedAs("The default period (ms) to wait for a synchronous response.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultTransactionTimeout").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo("30000").describedAs("The default timeout (ms) for transactions. This can also be configured on transactions, in which case the transaction configuration is used instead of this default.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultErrorHandler-ref").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("The default error handler for every flow. This must be a reference to a global error handler.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("shutdownTimeout").ofType(typeLoader.load((Type)((Object)Integer.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo("5000").describedAs("The time in milliseconds to wait for any in-progress work to finish running before Mule shuts down. After this threshold has been reached, Mule starts stopping schedulers and interrupting threads, and messages can be lost. If you have a very large number of services in the same Mule instance, if you have components that take more than a couple seconds to process, or if you are using large payloads and/or slower transports, you should increase this value to allow more time for graceful shutdown. The value you specify is applied to services and separately to dispatchers, so the default value of 5000 milliseconds specifies that Mule has ten seconds to process and dispatch messages gracefully after shutdown is initiated.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("maxQueueTransactionFilesSize").ofType(typeLoader.load((Type)((Object)Integer.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).defaultingTo("500").describedAs("The approximated maximum space in megabytes used by the transaction log files for transactional persistent queues. Take into account that this number applies both to the set of transaction log files for XA and for local transactions. If both type of transactions are used then the approximated maximum space used will be twice the configured value.");
        ((OptionalParameterDeclarer)((OptionalParameterDeclarer)configuration.onDefaultParameterGroup().withOptionalParameter("defaultObjectSerializer-ref").ofType(typeLoader.load((Type)((Object)String.class)))).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED)).describedAs("An optional reference to an ObjectSerializer to be used as the application's default");
    }
}

