/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.InternalEventContext;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.MessagingExceptionHandler;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MessageProcessors {
    private MessageProcessors() {
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof MessageProcessorChain && !(processors.get(0) instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain)) {
            return (MessageProcessorChain)processors.get(0);
        }
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder();
        processingStrategy.ifPresent(x$0 -> defaultMessageProcessorChainBuilder.setProcessingStrategy((ProcessingStrategy)x$0));
        return defaultMessageProcessorChainBuilder.chain(processors).build();
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, Processor ... processors) {
        return MessageProcessors.newChain(processingStrategy, Arrays.asList(processors));
    }

    public static MessageProcessorChain newExplicitChain(Optional<ProcessingStrategy> processingStrategy, Processor ... processors) {
        if (processors.length == 1 && processors[0] instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain) {
            return (MessageProcessorChain)processors[0];
        }
        ExplicitMessageProcessorChainBuilder explicitMessageProcessorChainBuilder = new ExplicitMessageProcessorChainBuilder();
        processingStrategy.ifPresent(x$0 -> explicitMessageProcessorChainBuilder.setProcessingStrategy((ProcessingStrategy)x$0));
        return explicitMessageProcessorChainBuilder.chain(processors).build();
    }

    public static MessageProcessorChain newExplicitChain(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof ExplicitMessageProcessorChainBuilder.ExplicitMessageProcessorChain) {
            return (MessageProcessorChain)processors.get(0);
        }
        ExplicitMessageProcessorChainBuilder explicitMessageProcessorChainBuilder = new ExplicitMessageProcessorChainBuilder();
        processingStrategy.ifPresent(x$0 -> explicitMessageProcessorChainBuilder.setProcessingStrategy((ProcessingStrategy)x$0));
        return explicitMessageProcessorChainBuilder.chain(processors).build();
    }

    public static InternalEvent processToApply(InternalEvent event, ReactiveProcessor processor) throws MuleException {
        try {
            return (InternalEvent)Mono.just((Object)event).transform((Function)processor).switchIfEmpty(Mono.from(event.getContext().getResponsePublisher())).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static InternalEvent processToApplyWithChildContext(InternalEvent event, ReactiveProcessor processor) throws MuleException {
        try {
            return (InternalEvent)Mono.just((Object)event).transform(publisher -> Mono.from((Publisher)publisher).then(request -> Mono.from(MessageProcessors.internalProcessWithChildContext(request, processor, DefaultEventContext.child(event.getContext(), Optional.empty()), false)))).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static Publisher<InternalEvent> processWithChildContext(InternalEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, DefaultEventContext.child(event.getContext(), componentLocation), true);
    }

    public static Publisher<InternalEvent> processWithChildContext(InternalEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, MessagingExceptionHandler exceptionHandler) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, DefaultEventContext.child(event.getContext(), componentLocation, exceptionHandler), true);
    }

    private static Publisher<InternalEvent> internalProcessWithChildContext(InternalEvent event, ReactiveProcessor processor, InternalEventContext child, boolean completeParentOnEmpty) {
        return Mono.just((Object)InternalEvent.builder(child, event).build()).transform((Function)processor).doOnNext(result -> {
            if (!Mono.from(child.getResponsePublisher()).toFuture().isDone()) {
                child.success((InternalEvent)result);
            }
        }).switchIfEmpty(Mono.from(child.getResponsePublisher())).map(result -> InternalEvent.builder(event.getContext(), result).build()).doOnError(MessagingException.class, me -> me.setProcessedEvent(InternalEvent.builder(event.getContext(), me.getEvent()).build())).doOnSuccess(result -> {
            if (result == null && completeParentOnEmpty) {
                event.getContext().success();
            }
        });
    }

    public static Optional<ProcessingStrategy> getProcessingStrategy(MuleContext muleContext, String rootContainerName) {
        Optional<ProcessingStrategy> processingStrategy = Optional.empty();
        Object object = muleContext.getRegistry().get(rootContainerName);
        if (object instanceof FlowConstruct) {
            processingStrategy = Optional.of(muleContext.getRegistry().lookupFlowConstruct(rootContainerName).getProcessingStrategy());
        }
        return processingStrategy;
    }
}

