/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;

public class DefaultConnectionProviderWrapper<C>
extends ConnectionProviderWrapper<C> {
    private final MuleContext muleContext;
    private final ConnectionManagerAdapter connectionManager;

    public DefaultConnectionProviderWrapper(ConnectionProvider<C> delegate, MuleContext muleContext) {
        super(delegate);
        this.muleContext = muleContext;
        this.connectionManager = (ConnectionManagerAdapter)muleContext.getRegistry().get("_muleConnectionManager");
    }

    @Override
    public C connect() throws ConnectionException {
        Object connection = super.connect();
        try {
            this.muleContext.getInjector().inject(connection);
        }
        catch (MuleException e) {
            throw new ConnectionException("Could not initialise connection", (Throwable)e);
        }
        return connection;
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        ConnectionProvider delegate = this.getDelegate();
        if (delegate instanceof ConnectionProviderWrapper) {
            return ((ConnectionProviderWrapper)delegate).getRetryPolicyTemplate();
        }
        return this.connectionManager.getDefaultRetryPolicyTemplate();
    }

    @Override
    public Optional<PoolingProfile> getPoolingProfile() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getPoolingProfile() : Optional.empty();
    }
}

