/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.internal.exception.TemplateOnErrorHandler;
import org.mule.runtime.core.internal.message.InternalMessage;

public class OnErrorContinueHandler
extends TemplateOnErrorHandler {
    private ErrorTypeMatcher sourceErrorMatcher;

    public OnErrorContinueHandler() {
        this.setHandleException(true);
    }

    @Override
    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        ErrorTypeRepository errorTypeRepository = muleContext.getErrorTypeRepository();
        this.sourceErrorMatcher = new SingleErrorTypeMatcher(errorTypeRepository.getSourceResponseErrorType());
        if (this.errorType != null) {
            String[] errors;
            for (String error : errors = this.errorType.split(",")) {
                String sanitizedError = error.trim();
                ErrorType errorType = errorTypeRepository.lookupErrorType(ComponentIdentifier.buildFromStringRepresentation(sanitizedError)).get();
                if (!this.sourceErrorMatcher.match(errorType)) continue;
                throw new InitialisationException(this.getInitialisationError(sanitizedError), (Initialisable)this);
            }
        }
    }

    private I18nMessage getInitialisationError(String type) {
        return I18nMessageFactory.createStaticMessage(String.format("Source errors are not allowed in 'on-error-continue' handlers. Offending type is '%s'.", type));
    }

    @Override
    protected InternalEvent nullifyExceptionPayloadIfRequired(InternalEvent event) {
        return InternalEvent.builder(event).error(null).message(InternalMessage.builder(event.getMessage()).exceptionPayload(null).build()).build();
    }

    @Override
    public boolean accept(InternalEvent event) {
        return !this.sourceError(event) && super.accept(event);
    }

    private boolean sourceError(InternalEvent event) {
        return event.getError().filter(error -> this.sourceErrorMatcher.match(event.getError().get().getErrorType())).isPresent();
    }
}

