/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.ErrorTypeMatcher;
import org.mule.runtime.core.api.exception.ErrorTypeRepository;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.execution.MessageProcessContext;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.api.functional.Either;
import org.mule.runtime.core.api.message.ErrorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessors;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhaseTemplate;
import org.mule.runtime.core.internal.execution.NotificationFiringProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseResultNotifier;
import org.mule.runtime.core.internal.execution.SourceErrorException;
import org.mule.runtime.core.internal.execution.SourceResultAdapter;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.internal.policy.SourcePolicy;
import org.mule.runtime.core.internal.policy.SourcePolicyFailureResult;
import org.mule.runtime.core.internal.policy.SourcePolicySuccessResult;
import org.mule.runtime.core.internal.util.FunctionalUtils;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class ModuleFlowProcessingPhase
extends NotificationFiringProcessingPhase<ModuleFlowProcessingPhaseTemplate>
implements Initialisable {
    private static Logger LOGGER = LoggerFactory.getLogger(ModuleFlowProcessingPhase.class);
    private ErrorTypeMatcher sourceResponseErrorTypeMatcher;
    private ErrorType sourceResponseGenerateErrorType;
    private ErrorType sourceResponseSendErrorType;
    private ErrorType sourceErrorResponseGenerateErrorType;
    private ErrorType sourceErrorResponseSendErrorType;
    private final PolicyManager policyManager;

    public ModuleFlowProcessingPhase(PolicyManager policyManager) {
        this.policyManager = policyManager;
    }

    @Override
    public void initialise() throws InitialisationException {
        ErrorTypeRepository errorTypeRepository = this.muleContext.getErrorTypeRepository();
        this.sourceResponseErrorTypeMatcher = new SingleErrorTypeMatcher(errorTypeRepository.getSourceResponseErrorType());
        this.sourceResponseGenerateErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_RESPONSE_GENERATE).get();
        this.sourceResponseSendErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_RESPONSE_SEND).get();
        this.sourceErrorResponseGenerateErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_GENERATE).get();
        this.sourceErrorResponseSendErrorType = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.SOURCE_ERROR_RESPONSE_SEND).get();
    }

    @Override
    public boolean supportsTemplate(MessageProcessTemplate messageProcessTemplate) {
        return messageProcessTemplate instanceof ModuleFlowProcessingPhaseTemplate;
    }

    @Override
    public void runPhase(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier) {
        try {
            MessageSource messageSource = messageProcessContext.getMessageSource();
            FlowConstruct flowConstruct = (FlowConstruct)this.muleContext.getConfigurationComponentLocator().find(Location.builder().globalName(messageSource.getRootContainerName()).build()).get();
            ComponentLocation sourceLocation = messageSource.getLocation();
            Consumer<Either<MessagingException, InternalEvent>> terminateConsumer = this.getTerminateConsumer(messageSource, template);
            MonoProcessor responseCompletion = MonoProcessor.create();
            InternalEvent templateEvent = this.createEvent(template, sourceLocation, (Publisher<Void>)responseCompletion, flowConstruct);
            SourcePolicy policy = this.policyManager.createSourcePolicyInstance(sourceLocation, templateEvent, new FlowProcessor(template, templateEvent), template);
            PhaseContext phaseContext = new PhaseContext(template, messageProcessContext, phaseResultNotifier, terminateConsumer);
            Mono.just((Object)templateEvent).doOnNext(this.onMessageReceived(messageProcessContext, flowConstruct)).then(request -> Mono.from(policy.process((InternalEvent)request))).then(policyResult -> policyResult.reduce(this.policyFailure(phaseContext, flowConstruct), this.policySuccess(phaseContext, flowConstruct))).doOnSuccess(aVoid -> phaseResultNotifier.phaseSuccessfully()).doOnError(this.onFailure(phaseResultNotifier, terminateConsumer)).doAfterTerminate((event, throwable) -> responseCompletion.onComplete()).subscribe();
        }
        catch (Exception e) {
            phaseResultNotifier.phaseFailure(e);
        }
    }

    private Consumer<InternalEvent> onMessageReceived(MessageProcessContext messageProcessContext, FlowConstruct flowConstruct) {
        return request -> this.fireNotification(messageProcessContext.getMessageSource(), (InternalEvent)request, flowConstruct, 801);
    }

    private Function<SourcePolicySuccessResult, Mono<Void>> policySuccess(PhaseContext ctx, FlowConstruct flowConstruct) {
        return successResult -> {
            this.fireNotification(ctx.messageProcessContext.getMessageSource(), successResult.getResult(), flowConstruct, 805);
            try {
                return Mono.from(ctx.template.sendResponseToClient(successResult.getResult(), successResult.getResponseParameters().get())).doOnSuccess(v -> this.onTerminate(ctx.terminateConsumer, Either.right(successResult.getResult()))).onErrorResume(e -> this.policySuccessError(new SourceErrorException(successResult.getResult(), this.sourceResponseSendErrorType, (Throwable)e), (SourcePolicySuccessResult)successResult, ctx, flowConstruct));
            }
            catch (Exception e2) {
                return this.policySuccessError(new SourceErrorException(successResult.getResult(), this.sourceResponseGenerateErrorType, e2), (SourcePolicySuccessResult)successResult, ctx, flowConstruct);
            }
        };
    }

    private Function<SourcePolicyFailureResult, Mono<Void>> policyFailure(PhaseContext ctx, FlowConstruct flowConstruct) {
        return failureResult -> {
            this.fireNotification(ctx.messageProcessContext.getMessageSource(), failureResult.getMessagingException().getEvent(), flowConstruct, 806);
            return this.sendErrorResponse(failureResult.getMessagingException(), event -> failureResult.getErrorResponseParameters().get(), ctx);
        };
    }

    private Mono<Void> policySuccessError(SourceErrorException see, SourcePolicySuccessResult successResult, PhaseContext ctx, FlowConstruct flowConstruct) {
        MessagingException messagingException = see.toMessagingException();
        return Mono.when((Mono)Mono.just((Object)messagingException).flatMapMany((Function)flowConstruct.getExceptionListener()).last().onErrorResume(e -> Mono.empty()), (Mono)this.sendErrorResponse(messagingException, successResult.createErrorResponseParameters(), ctx).doOnSuccess(v -> this.onTerminate(ctx.terminateConsumer, Either.right(see.getEvent())))).then();
    }

    private Mono<Void> sendErrorResponse(MessagingException messagingException, Function<InternalEvent, Map<String, Object>> errorParameters, PhaseContext ctx) {
        InternalEvent event = messagingException.getEvent();
        if (messagingException.inErrorHandler()) {
            return Mono.error((Throwable)new SourceErrorException(event, this.sourceErrorResponseGenerateErrorType, messagingException.getCause(), messagingException));
        }
        try {
            return Mono.from(ctx.template.sendFailureResponseToClient(messagingException, errorParameters.apply(event))).onErrorMap(e -> new SourceErrorException(InternalEvent.builder(messagingException.getEvent()).error(ErrorBuilder.builder(e).errorType(this.sourceErrorResponseSendErrorType).build()).build(), this.sourceErrorResponseSendErrorType, (Throwable)e)).doOnSuccess(v -> this.onTerminate(ctx.terminateConsumer, Either.left(messagingException)));
        }
        catch (Exception e2) {
            return Mono.error((Throwable)new SourceErrorException(event, this.sourceErrorResponseGenerateErrorType, e2, messagingException));
        }
    }

    private Consumer<Throwable> onFailure(PhaseResultNotifier phaseResultNotifier, Consumer<Either<MessagingException, InternalEvent>> terminateConsumer) {
        return throwable -> {
            this.onTerminate(terminateConsumer, Either.left(throwable));
            throwable = throwable instanceof SourceErrorException ? throwable.getCause() : throwable;
            Exception failureException = throwable instanceof Exception ? (Exception)throwable : new DefaultMuleException((Throwable)throwable);
            phaseResultNotifier.phaseFailure(failureException);
        };
    }

    private Consumer<Either<MessagingException, InternalEvent>> getTerminateConsumer(MessageSource messageSource, ModuleFlowProcessingPhaseTemplate template) {
        return eventOrException -> template.sendAfterTerminateResponseToClient(eventOrException.mapLeft(messagingException -> {
            messagingException.setProcessedEvent(ExceptionUtils.createErrorEvent(messagingException.getEvent(), messageSource, messagingException, this.muleContext.getErrorTypeLocator()));
            return messagingException;
        }));
    }

    private InternalEvent createEvent(ModuleFlowProcessingPhaseTemplate template, ComponentLocation sourceLocation, Publisher<Void> responseCompletion, FlowConstruct flowConstruct) throws MuleException {
        Message message = template.getMessage();
        InternalEvent templateEvent = InternalEvent.builder(DefaultEventContext.create(flowConstruct, sourceLocation, null, responseCompletion)).message(message).flow(flowConstruct).build();
        if (message.getPayload().getValue() instanceof SourceResultAdapter) {
            SourceResultAdapter adapter = (SourceResultAdapter)message.getPayload().getValue();
            Result result = adapter.getResult();
            Object resultValue = result.getOutput();
            message = resultValue instanceof Collection && adapter.isCollection() ? MessageUtils.toMessage(Result.builder().output(MessageUtils.toMessageCollection((Collection)resultValue, adapter.getCursorProviderFactory(), templateEvent)).mediaType(result.getMediaType().orElse(MediaType.ANY)).build()) : MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), adapter.getCursorProviderFactory(), templateEvent);
            templateEvent = InternalEvent.builder(templateEvent).message(message).build();
        }
        return templateEvent;
    }

    private InternalEvent emptyEvent(InternalEvent request) {
        return InternalEvent.builder(request).message(Message.of(null)).build();
    }

    private void onTerminate(Consumer<Either<MessagingException, InternalEvent>> terminateConsumer, Either<Throwable, InternalEvent> result) {
        FunctionalUtils.safely(() -> terminateConsumer.accept(result.mapLeft(throwable -> {
            if (throwable instanceof MessagingException) {
                return (MessagingException)throwable;
            }
            if (throwable instanceof SourceErrorException) {
                return ((SourceErrorException)throwable).toMessagingException();
            }
            return null;
        })));
    }

    @Override
    public int compareTo(MessageProcessPhase messageProcessPhase) {
        if (messageProcessPhase instanceof ValidationPhase) {
            return 1;
        }
        return 0;
    }

    private static final class PhaseContext {
        final ModuleFlowProcessingPhaseTemplate template;
        final MessageProcessContext messageProcessContext;
        final PhaseResultNotifier phaseResultNotifier;
        final Consumer<Either<MessagingException, InternalEvent>> terminateConsumer;

        PhaseContext(ModuleFlowProcessingPhaseTemplate template, MessageProcessContext messageProcessContext, PhaseResultNotifier phaseResultNotifier, Consumer<Either<MessagingException, InternalEvent>> terminateConsumer) {
            this.template = template;
            this.messageProcessContext = messageProcessContext;
            this.phaseResultNotifier = phaseResultNotifier;
            this.terminateConsumer = terminateConsumer;
        }
    }

    private class FlowProcessor
    implements Processor {
        private final ModuleFlowProcessingPhaseTemplate template;
        private final InternalEvent templateEvent;

        public FlowProcessor(ModuleFlowProcessingPhaseTemplate template, InternalEvent templateEvent) {
            this.template = template;
            this.templateEvent = templateEvent;
        }

        @Override
        public InternalEvent process(InternalEvent event) throws MuleException {
            return MessageProcessors.processToApply(event, this);
        }

        @Override
        public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
            return Mono.from(publisher).then(request -> Mono.from(this.template.routeEventAsync((InternalEvent)request)).switchIfEmpty(Mono.fromCallable(() -> ModuleFlowProcessingPhase.this.emptyEvent(this.templateEvent))));
        }
    }
}

