/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.api.context.notification.NotificationHelper;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.execution.MessageProcessTemplate;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NotificationFiringProcessingPhase<Template extends MessageProcessTemplate>
implements MessageProcessPhase<Template>,
Comparable<MessageProcessPhase>,
MuleContextAware {
    protected transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<ServerNotificationManager, NotificationHelper> notificationHelpers = new ConcurrentHashMap();
    protected MuleContext muleContext;

    protected void fireNotification(Object source, InternalEvent event, FlowConstruct flow, int action) {
        try {
            if (event == null && (event = InternalEvent.getCurrentEvent()) == null) {
                return;
            }
            this.getNotificationHelper(this.muleContext.getNotificationManager()).fireNotification(source, event, flow, action);
        }
        catch (Exception e) {
            this.logger.warn("Could not fire notification. Action: " + action, (Throwable)e);
        }
    }

    protected NotificationHelper getNotificationHelper(ServerNotificationManager serverNotificationManager) {
        NotificationHelper notificationHelper = this.notificationHelpers.get(serverNotificationManager);
        if (notificationHelper == null) {
            notificationHelper = new NotificationHelper(serverNotificationManager, ConnectorMessageNotification.class, false);
            this.notificationHelpers.putIfAbsent(serverNotificationManager, notificationHelper);
        }
        return notificationHelper;
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }
}

