/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.lifecycle.phases;

import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.PostConstruct;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.component.Component;
import org.mule.runtime.core.api.config.Config;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.lifecycle.LifecycleObject;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.routing.OutboundRouter;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transport.LegacyConnector;
import org.mule.runtime.core.internal.lifecycle.phases.DefaultLifecyclePhase;
import org.mule.runtime.core.privileged.util.annotation.AnnotationMetaData;
import org.mule.runtime.core.privileged.util.annotation.AnnotationUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;

public class MuleContextInitialisePhase
extends DefaultLifecyclePhase {
    public MuleContextInitialisePhase() {
        super("initialise", Initialisable.class, "dispose");
        this.registerSupportedPhase("not in lifecycle");
        LinkedHashSet<LifecycleObject> orderedObjects = new LinkedHashSet<LifecycleObject>();
        orderedObjects.add(new LifecycleObject(StreamingManager.class));
        orderedObjects.add(new LifecycleObject(ConfigurationProvider.class));
        orderedObjects.add(new LifecycleObject(Config.class));
        orderedObjects.add(new LifecycleObject(LegacyConnector.class));
        orderedObjects.add(new LifecycleObject(SecurityManager.class));
        orderedObjects.add(new LifecycleObject(FlowConstruct.class));
        orderedObjects.add(new LifecycleObject(Initialisable.class));
        this.setOrderedLifecycleObjects(orderedObjects);
        this.setIgnoredObjectTypes(new Class[]{Component.class, MessageSource.class, InterceptingMessageProcessor.class, OutboundRouter.class, MuleContext.class});
    }

    @Override
    public void applyLifecycle(Object o) throws LifecycleException {
        super.applyLifecycle(o);
        if (o == null) {
            return;
        }
        if (this.ignoreType(o.getClass())) {
            return;
        }
        List<AnnotationMetaData> annos = AnnotationUtils.getMethodAnnotations(o.getClass(), PostConstruct.class);
        if (annos.size() == 1) {
            AnnotationMetaData anno = annos.get(0);
            try {
                ((Method)anno.getMember()).invoke(o, new Object[0]);
            }
            catch (Exception e) {
                throw new LifecycleException(CoreMessages.failedToInvokeLifecycle(anno.getMember().getName(), o), e, this);
            }
        }
    }
}

