/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.interceptor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.meta.AnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.exception.MessagingException;
import org.mule.runtime.core.api.processor.ParametersResolverProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.interception.DefaultInterceptionEvent;
import org.mule.runtime.core.internal.processor.interceptor.InterceptionException;
import org.mule.runtime.core.internal.processor.interceptor.ReactiveInterceptionAction;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ReactiveInterceptorAdapter
implements BiFunction<Processor, ReactiveProcessor, ReactiveProcessor>,
MuleContextAware {
    private static final String INTERCEPTION_COMPONENT = "core:interceptionComponent";
    private static final String AROUND_METHOD_NAME = "around";
    private ProcessorInterceptorFactory interceptorFactory;
    private MuleContext muleContext;

    public ReactiveInterceptorAdapter(ProcessorInterceptorFactory interceptorFactory) {
        this.interceptorFactory = interceptorFactory;
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Override
    public ReactiveProcessor apply(Processor component, ReactiveProcessor next) {
        if (!this.isInterceptable(component)) {
            return next;
        }
        ComponentLocation componentLocation = ((AnnotatedObject)((Object)component)).getLocation();
        if (!this.interceptorFactory.intercept(componentLocation)) {
            return next;
        }
        ProcessorInterceptor interceptor = (ProcessorInterceptor)this.interceptorFactory.get();
        Map dslParameters = (Map)((AnnotatedObject)((Object)component)).getAnnotation(ComponentAnnotations.ANNOTATION_PARAMETERS);
        if (this.implementsAround(interceptor)) {
            return publisher -> Mono.from((Publisher)publisher).map(this.doBefore(interceptor, component, dslParameters)).flatMapMany(event -> Mono.fromFuture(this.doAround((InternalEvent)event, interceptor, component, dslParameters, next)).onErrorMap(CompletionException.class, completionException -> completionException.getCause())).doOnError(MessagingException.class, error -> this.doAfter(componentLocation, interceptor, Optional.of(error.getCause())).apply(error.getEvent())).map(this.doAfter(componentLocation, interceptor, Optional.empty()));
        }
        return publisher -> Mono.from((Publisher)publisher).map(this.doBefore(interceptor, component, dslParameters)).transform((Function)next).doOnError(MessagingException.class, error -> this.doAfter(componentLocation, interceptor, Optional.of(error.getCause())).apply(error.getEvent())).map(this.doAfter(componentLocation, interceptor, Optional.empty()));
    }

    private boolean implementsAround(ProcessorInterceptor interceptor) {
        try {
            return !interceptor.getClass().getMethod(AROUND_METHOD_NAME, ComponentLocation.class, Map.class, InterceptionEvent.class, InterceptionAction.class).isDefault();
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new MuleRuntimeException(e);
        }
    }

    private Function<InternalEvent, InternalEvent> doBefore(ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.addResolvedParameters((InternalEvent)event, component, dslParameters);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            interceptor.before(((AnnotatedObject)((Object)component)).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent);
            return interceptionEvent.resolve();
        };
    }

    private CompletableFuture<InternalEvent> doAround(InternalEvent event, ProcessorInterceptor interceptor, Processor component, Map<String, String> dslParameters, ReactiveProcessor next) {
        InternalEvent eventWithResolvedParams = this.addResolvedParameters(event, component, dslParameters);
        DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
        ReactiveInterceptionAction reactiveInterceptionAction = new ReactiveInterceptionAction(interceptionEvent, next, component, this.muleContext);
        return ((CompletableFuture)interceptor.around(((AnnotatedObject)((Object)component)).getLocation(), this.getResolvedParams(eventWithResolvedParams), interceptionEvent, reactiveInterceptionAction).exceptionally(t -> {
            if (t instanceof MessagingException) {
                throw new CompletionException((Throwable)t);
            }
            throw new CompletionException(ExceptionUtils.updateMessagingExceptionWithError(new MessagingException(eventWithResolvedParams, t.getCause(), component), component, this.muleContext));
        })).thenApply(interceptedEvent -> ((DefaultInterceptionEvent)interceptedEvent).resolve());
    }

    private Map<String, Object> getResolvedParams(InternalEvent eventWithResolvedParams) {
        return (Map)eventWithResolvedParams.getInternalParameters().get("core:interceptionResolvedParams");
    }

    private Function<InternalEvent, InternalEvent> doAfter(ComponentLocation componentLocation, ProcessorInterceptor interceptor, Optional<Throwable> thrown) {
        return event -> {
            InternalEvent eventWithResolvedParams = this.removeResolvedParameters((InternalEvent)event);
            DefaultInterceptionEvent interceptionEvent = new DefaultInterceptionEvent(eventWithResolvedParams);
            interceptor.after(componentLocation, interceptionEvent, thrown);
            return interceptionEvent.resolve();
        };
    }

    private boolean isInterceptable(Processor component) {
        ComponentLocation componentLocation;
        return component instanceof AnnotatedObject && (componentLocation = ((AnnotatedObject)((Object)component)).getLocation()) != null;
    }

    private InternalEvent addResolvedParameters(InternalEvent event, Processor component, Map<String, String> dslParameters) {
        boolean sameComponent;
        boolean bl = sameComponent = event.getInternalParameters().containsKey(INTERCEPTION_COMPONENT) ? component.equals(event.getInternalParameters().get(INTERCEPTION_COMPONENT)) : false;
        if (!sameComponent || !event.getInternalParameters().containsKey("core:interceptionResolvedParams")) {
            return this.resolveParameters(this.removeResolvedParameters(event), component, dslParameters);
        }
        return event;
    }

    private InternalEvent removeResolvedParameters(InternalEvent event) {
        Processor processor;
        if (event.getInternalParameters().containsKey("core:interceptionResolvedContext") && (processor = (Processor)event.getInternalParameters().get(INTERCEPTION_COMPONENT)) instanceof ParametersResolverProcessor) {
            ((ParametersResolverProcessor)((Object)processor)).disposeResolvedParameters((ExecutionContext)event.getInternalParameters().get("core:interceptionResolvedContext"));
        }
        return InternalEvent.builder(event).removeInternalParameter("core:interceptionResolvedParams").removeInternalParameter(INTERCEPTION_COMPONENT).removeInternalParameter("core:interceptionResolvedContext").build();
    }

    private InternalEvent resolveParameters(InternalEvent event, Processor processor, Map<String, String> parameters) {
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String paramValue = entry.getValue();
            String value = this.muleContext.getExpressionManager().isExpression(paramValue) ? this.muleContext.getExpressionManager().evaluate(paramValue, event, ((AnnotatedObject)((Object)processor)).getLocation()).getValue() : String.valueOf(paramValue);
            resolvedParameters.put(entry.getKey(), value);
        }
        HashMap<String, Object> interceptionEventParams = new HashMap<String, Object>();
        if (processor instanceof ParametersResolverProcessor) {
            try {
                ParametersResolverProcessor.ParametersResolverProcessorResult resolveParameters = ((ParametersResolverProcessor)((Object)processor)).resolveParameters(event);
                resolvedParameters.putAll(resolveParameters.getParameters());
                interceptionEventParams.put("core:interceptionResolvedContext", resolveParameters.getContext());
            }
            catch (MuleException e) {
                throw new InterceptionException(e);
            }
        }
        interceptionEventParams.put("core:interceptionResolvedParams", resolvedParameters);
        interceptionEventParams.put(INTERCEPTION_COMPONENT, processor);
        return InternalEvent.builder(event).internalParameters(interceptionEventParams).build();
    }
}

