/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.resolving;

import java.util.Optional;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.resolving.ExtensionResolvingContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class DefaultExtensionResolvingContext
implements ExtensionResolvingContext {
    private final Optional<ConfigurationInstance> configInstance;
    private final ClassTypeLoader typeLoader;
    private final ConnectionHandler connectionHandler;

    public DefaultExtensionResolvingContext(Optional<ConfigurationInstance> configInstance, ConnectionManager connectionManager, ClassTypeLoader typeLoader) throws ConnectionException {
        this.configInstance = configInstance;
        this.typeLoader = typeLoader;
        this.connectionHandler = configInstance.isPresent() && configInstance.get().getConnectionProvider().isPresent() ? connectionManager.getConnection(configInstance.get().getValue()) : null;
    }

    @Override
    public <C> Optional<C> getConfig() {
        return this.configInstance.map(ConfigurationInstance::getValue);
    }

    @Override
    public <C> Optional<C> getConnection() throws ConnectionException {
        return this.connectionHandler != null ? Optional.of(this.connectionHandler.getConnection()) : Optional.empty();
    }

    @Override
    public ClassTypeLoader getTypeLoader() {
        return this.typeLoader;
    }

    @Override
    public BaseTypeBuilder getTypeBuilder() {
        return BaseTypeBuilder.create(MetadataFormat.JAVA);
    }

    @Override
    public void dispose() {
        if (this.connectionHandler != null) {
            this.connectionHandler.release();
        }
    }
}

