/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.source.scheduler;

import java.util.concurrent.ScheduledFuture;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.source.SchedulerMessageSource;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.context.notification.ConnectorMessageNotification;
import org.mule.runtime.core.api.context.notification.NotificationHelper;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.source.polling.PeriodicScheduler;
import org.mule.runtime.core.internal.util.rx.Operators;
import reactor.core.publisher.Mono;

public class DefaultSchedulerMessageSource
extends AbstractAnnotatedObject
implements MessageSource,
SchedulerMessageSource,
MuleContextAware,
Initialisable,
Disposable {
    private final PeriodicScheduler scheduler;
    private final NotificationHelper notificationHelper;
    private Scheduler pollingExecutor;
    private ScheduledFuture<?> schedulingJob;
    private Processor listener;
    private FlowConstruct flowConstruct;
    private MuleContext muleContext;
    private boolean started;

    public DefaultSchedulerMessageSource(MuleContext muleContext, PeriodicScheduler scheduler) {
        this.muleContext = muleContext;
        this.scheduler = scheduler;
        this.notificationHelper = new NotificationHelper(muleContext.getNotificationManager(), ConnectorMessageNotification.class, false);
    }

    @Override
    public synchronized void start() throws MuleException {
        if (this.started) {
            return;
        }
        try {
            this.schedulingJob = this.scheduler.schedule(this.pollingExecutor, () -> this.run());
            this.started = true;
        }
        catch (Exception ex) {
            this.stop();
            throw new CreateException(CoreMessages.failedToScheduleWork(), ex, this);
        }
    }

    @Override
    public synchronized void stop() throws MuleException {
        if (!this.started) {
            return;
        }
        if (this.schedulingJob != null) {
            this.schedulingJob.cancel(false);
            this.schedulingJob = null;
        }
        this.started = false;
    }

    @Override
    public void trigger() {
        this.pollingExecutor.execute(() -> this.poll());
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    private final void run() {
        InternalEvent.setCurrentEvent(null);
        if (!this.pollOnPrimaryInstanceOnly() || this.muleContext.isPrimaryPollingInstance()) {
            this.poll();
        }
    }

    private boolean pollOnPrimaryInstanceOnly() {
        return true;
    }

    private void poll() {
        Message request = Message.of(null);
        this.pollWith(request);
    }

    private void pollWith(Message request) {
        try {
            Mono.just((Object)request).map(message -> InternalEvent.builder(DefaultEventContext.create(this.muleContext.getUniqueIdString(), this.muleContext.getId(), this.getLocation())).message(request).flow(this.flowConstruct).build()).doOnNext(event -> InternalEvent.setCurrentEvent(event)).doOnNext(event -> this.notificationHelper.fireNotification(this, (InternalEvent)event, this.getLocation(), this.muleContext, 801)).transform((Function)this.listener).subscribe(Operators.requestUnbounded());
        }
        catch (Exception e) {
            this.muleContext.getExceptionListener().handleException(e);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        this.flowConstruct = FlowConstruct.getFromAnnotatedObject(this.muleContext.getConfigurationComponentLocator(), this);
        this.createScheduler();
    }

    @Override
    public void dispose() {
        this.disposeScheduler();
    }

    private void createScheduler() throws InitialisationException {
        this.pollingExecutor = this.muleContext.getSchedulerService().cpuLightScheduler();
    }

    private void disposeScheduler() {
        if (this.pollingExecutor != null) {
            this.pollingExecutor.stop();
            this.pollingExecutor = null;
        }
    }

    @Override
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Override
    public void setListener(Processor listener) {
        this.listener = listener;
    }
}

