/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util;

import java.util.concurrent.locks.Lock;
import org.mule.runtime.core.api.util.func.CheckedRunnable;
import org.mule.runtime.core.api.util.func.CheckedSupplier;

public class ConcurrencyUtils {
    public static void safeUnlock(Lock lock) {
        try {
            lock.unlock();
        }
        catch (IllegalMonitorStateException illegalMonitorStateException) {
            // empty catch block
        }
    }

    public static <T> T withLock(Lock lock, CheckedSupplier<T> supplier) {
        lock.lock();
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            ConcurrencyUtils.safeUnlock(lock);
        }
    }

    public static void withLock(Lock lock, CheckedRunnable delegate) {
        lock.lock();
        try {
            delegate.run();
        }
        finally {
            ConcurrencyUtils.safeUnlock(lock);
        }
    }

    private ConcurrencyUtils() {
    }
}

