/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.event.InputEvent;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.DefaultEventContext;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeProcessorChainRouter
extends AbstractAnnotatedObject
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(CompositeProcessorChainRouter.class);
    @Inject
    private MuleContext muleContext;
    private String name;
    private List<MessageProcessorChain> processorChains = Collections.emptyList();

    public Event process(InputEvent inputEvent) throws MuleException {
        InternalEvent.Builder builder = InternalEvent.builder(DefaultEventContext.create(UUID.getUUID(), this.muleContext.getId(), this.getLocation()));
        InternalEvent defaultEvent = builder.variables(inputEvent.getVariables()).properties(inputEvent.getProperties()).parameters(inputEvent.getParameters()).message(inputEvent.getMessage()).error(inputEvent.getError().orElse(null)).build();
        for (MessageProcessorChain processorChain : this.processorChains) {
            defaultEvent = processorChain.process(defaultEvent);
        }
        return defaultEvent;
    }

    public void setProcessorChains(List processorChains) {
        this.processorChains = processorChains;
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processorChains);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processorChains, LOGGER);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processorChains);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.processorChains, this.muleContext);
    }
}

