/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.internal.processor.chain.ExplicitMessageProcessorChainBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorChainRouter
extends AbstractAnnotatedObject
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(ProcessorChainRouter.class);
    @Inject
    private MuleContext muleContext;
    private String name;
    private List<Processor> processors = Collections.emptyList();
    private MessageProcessorChain processorChain;

    public Event process(InternalEvent event) {
        try {
            return this.processorChain.process(event);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException(e);
        }
    }

    public void setProcessors(List processors) {
        this.processors = processors;
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processorChain);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processorChain, LOGGER);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processorChain);
    }

    @Override
    public void initialise() throws InitialisationException {
        ExplicitMessageProcessorChainBuilder builder = new ExplicitMessageProcessorChainBuilder();
        builder.setName("processor chain '" + this.name + "'");
        for (Processor processor : this.processors) {
            if (processor instanceof Processor) {
                builder.chain(processor);
                continue;
            }
            if (processor instanceof MessageProcessorBuilder) {
                builder.chain((MessageProcessorBuilder)((Object)processor));
                continue;
            }
            throw new IllegalArgumentException("MessageProcessorBuilder should only have MessageProcessor's or MessageProcessorBuilder's configured");
        }
        this.processorChain = builder.build();
        this.processorChain.setMuleContext(this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.processorChain, this.muleContext);
    }
}

