/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.AbstractAnnotatedObject;
import org.mule.runtime.core.api.InternalEvent;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.AnnotatedProcessor;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorBuilder;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.ReferenceProcessor;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;

public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageProcessorChainBuilder.class);

    @Override
    public MessageProcessorChain build() {
        LinkedList<Processor> tempList = new LinkedList<Processor>();
        LinkedList<Processor> processorsForLifecycle = new LinkedList<Processor>();
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            Processor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (processor instanceof InterceptingMessageProcessor && (!(processor instanceof ReferenceProcessor) || ((ReferenceProcessor)processor).getReferencedProcessor() instanceof InterceptingMessageProcessor)) {
                InterceptingMessageProcessor interceptingProcessor = (InterceptingMessageProcessor)processor;
                if (i + 1 < this.processors.size()) {
                    MessageProcessorChain innerChain = this.createSimpleChain(tempList);
                    processorsForLifecycle.addFirst(innerChain);
                    interceptingProcessor.setListener(innerChain);
                }
                tempList = new LinkedList<Processor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(processor);
        }
        Processor head = tempList.size() == 1 ? (Processor)tempList.get(0) : this.createSimpleChain(tempList);
        processorsForLifecycle.addFirst(head);
        return this.createInterceptingChain(head, this.processors, processorsForLifecycle);
    }

    protected MessageProcessorChain createSimpleChain(List<Processor> tempList) {
        if (tempList.size() == 1 && tempList.get(0) instanceof SimpleMessageProcessorChain) {
            return (MessageProcessorChain)tempList.get(0);
        }
        return new SimpleMessageProcessorChain("(inner chain) of " + this.name, Optional.ofNullable(this.processingStrategy), new ArrayList<Processor>(tempList));
    }

    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
        return new DefaultMessageProcessorChain("(outer intercepting chain) of " + this.name, Optional.ofNullable(this.processingStrategy), head, processors, processorsForLifecycle);
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(Processor ... processors) {
        for (Processor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<Processor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(Processor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    public static AnnotatedProcessor newLazyProcessorChainBuilder(final AbstractMessageProcessorChainBuilder chainBuilder, final MuleContext muleContext, final Supplier<ProcessingStrategy> processingStrategySupplier) {
        return new LazyProcessor(){
            private Processor processor;

            @Override
            public void initialise() throws InitialisationException {
                chainBuilder.setProcessingStrategy((ProcessingStrategy)processingStrategySupplier.get());
                this.processor = chainBuilder.build();
                LifecycleUtils.initialiseIfNeeded(this.processor, muleContext);
            }

            @Override
            public void start() throws MuleException {
                LifecycleUtils.startIfNeeded(this.processor);
            }

            @Override
            public void dispose() {
                LifecycleUtils.disposeIfNeeded(this.processor, LOGGER);
            }

            @Override
            public void stop() throws MuleException {
                LifecycleUtils.stopIfNeeded(this.processor);
            }

            @Override
            public InternalEvent process(InternalEvent event) throws MuleException {
                return this.processor.process(event);
            }

            @Override
            public Publisher<InternalEvent> apply(Publisher<InternalEvent> publisher) {
                return Flux.from(publisher).transform((Function)this.processor);
            }
        };
    }

    public static abstract class LazyProcessor
    extends AbstractAnnotatedObject
    implements AnnotatedProcessor,
    Lifecycle {
    }

    protected static class DefaultMessageProcessorChain
    extends AbstractMessageProcessorChain {
        private Processor head;
        private List<Processor> processorsForLifecycle;

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, processingStrategyOptional, processors);
            this.head = head;
            this.processorsForLifecycle = processorsForLifecycle;
        }

        @Override
        protected List<Processor> getMessageProcessorsForLifecycle() {
            return this.processorsForLifecycle;
        }

        @Override
        protected List<Processor> getProcessorsToExecute() {
            return Collections.singletonList(this.head);
        }
    }

    static class SimpleMessageProcessorChain
    extends AbstractMessageProcessorChain {
        SimpleMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors) {
            super(name, processingStrategyOptional, processors);
        }
    }
}

