/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerOnlyLookupStrategy;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.ChildOnlyLookupStrategy;
import org.mule.runtime.module.artifact.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.classloader.DelegateOnlyLookupStrategy;
import org.mule.runtime.module.artifact.classloader.LookupStrategy;
import org.mule.runtime.module.artifact.classloader.ParentFirstLookupStrategy;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.artifact.descriptor.BundleDependency;

public class DefaultRegionPluginClassLoadersFactory
implements RegionPluginClassLoadersFactory {
    public static final String PLUGIN_CLASSLOADER_IDENTIFIER = "/plugin/";
    private final ArtifactClassLoaderFactory artifactPluginClassLoaderFactory;
    private final ModuleRepository moduleRepository;

    public DefaultRegionPluginClassLoadersFactory(ArtifactClassLoaderFactory artifactPluginClassLoaderFactory, ModuleRepository moduleRepository) {
        Preconditions.checkArgument(artifactPluginClassLoaderFactory != null, "artifactPluginClassLoaderFactory cannot be null");
        Preconditions.checkArgument(moduleRepository != null, "moduleRepository cannot be null");
        this.artifactPluginClassLoaderFactory = artifactPluginClassLoaderFactory;
        this.moduleRepository = moduleRepository;
    }

    @Override
    public List<ArtifactClassLoader> createPluginClassLoaders(ArtifactClassLoader regionClassLoader, List<ArtifactPluginDescriptor> artifactPluginDescriptors, ClassLoaderLookupPolicy regionOwnerLookupPolicy) {
        LinkedList<ArtifactClassLoader> classLoaders = new LinkedList<ArtifactClassLoader>();
        for (ArtifactPluginDescriptor artifactPluginDescriptor : artifactPluginDescriptors) {
            String pluginArtifactId = DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(regionClassLoader.getArtifactId(), artifactPluginDescriptor.getName());
            ClassLoaderLookupPolicy pluginLookupPolicy = this.createPluginLookupPolicy(classLoaders, artifactPluginDescriptor, regionOwnerLookupPolicy, artifactPluginDescriptors);
            ArtifactClassLoader artifactClassLoader = this.artifactPluginClassLoaderFactory.create(pluginArtifactId, artifactPluginDescriptor, regionClassLoader.getClassLoader(), pluginLookupPolicy);
            classLoaders.add(artifactClassLoader);
        }
        return classLoaders;
    }

    public static String getArtifactPluginId(String parentArtifactId, String pluginName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)parentArtifactId), "parentArtifactId cannot be empty");
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)pluginName), "pluginName cannot be empty");
        return parentArtifactId + PLUGIN_CLASSLOADER_IDENTIFIER + pluginName;
    }

    private ClassLoaderLookupPolicy createPluginLookupPolicy(List<ArtifactClassLoader> classLoaders, ArtifactPluginDescriptor descriptor, ClassLoaderLookupPolicy baseLookupPolicy, List<ArtifactPluginDescriptor> artifactPluginDescriptors) {
        HashMap<String, LookupStrategy> pluginsLookupPolicies = new HashMap<String, LookupStrategy>();
        List<ArtifactPluginDescriptor> pluginDescriptors = this.getPluginDescriptors(descriptor, artifactPluginDescriptors);
        for (ArtifactPluginDescriptor dependencyPluginDescriptor : pluginDescriptors) {
            if (dependencyPluginDescriptor.getName().equals(descriptor.getName())) continue;
            LookupStrategy lookupStrategy = this.getClassLoaderLookupStrategy(descriptor, dependencyPluginDescriptor);
            for (String string : dependencyPluginDescriptor.getClassLoaderModel().getExportedPackages()) {
                pluginsLookupPolicies.put(string, lookupStrategy);
            }
            if (!this.isPrivilegedPluginDependency(descriptor, dependencyPluginDescriptor)) continue;
            Optional<ArtifactClassLoader> pluginClassLoader = classLoaders.stream().filter(c -> ((ArtifactDescriptor)c.getArtifactDescriptor()).getBundleDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId())).findFirst();
            if (!pluginClassLoader.isPresent()) {
                throw new IllegalStateException("Cannot find classloader for plugin: " + dependencyPluginDescriptor.getBundleDescriptor().getArtifactId());
            }
            lookupStrategy = new DelegateOnlyLookupStrategy(pluginClassLoader.get().getClassLoader());
            for (String exportedPackage3 : dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedExportedPackages()) {
                pluginsLookupPolicies.put(exportedPackage3, lookupStrategy);
            }
        }
        ContainerOnlyLookupStrategy containerOnlyLookupStrategy = new ContainerOnlyLookupStrategy(this.getClass().getClassLoader());
        for (MuleModule module : this.moduleRepository.getModules()) {
            if (!module.getPrivilegedArtifacts().contains(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())) continue;
            for (String string : module.getPrivilegedExportedPackages()) {
                pluginsLookupPolicies.put(string, containerOnlyLookupStrategy);
            }
        }
        return baseLookupPolicy.extend(pluginsLookupPolicies);
    }

    private List<ArtifactPluginDescriptor> getPluginDescriptors(ArtifactPluginDescriptor descriptor, List<ArtifactPluginDescriptor> artifactPluginDescriptors) {
        return artifactPluginDescriptors.stream().filter(d -> this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), (ArtifactPluginDescriptor)d)).collect(Collectors.toList());
    }

    private boolean isPrivilegedPluginDependency(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        if (dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedExportedPackages().isEmpty()) {
            return false;
        }
        return dependencyPluginDescriptor.getClassLoaderModel().getPrivilegedArtifacts().stream().filter(a -> a.startsWith(descriptor.getBundleDescriptor().getGroupId() + ":" + descriptor.getBundleDescriptor().getArtifactId())).findFirst().isPresent();
    }

    private LookupStrategy getClassLoaderLookupStrategy(ArtifactPluginDescriptor descriptor, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        LookupStrategy lookupStrategy = this.isDependencyPlugin(descriptor.getClassLoaderModel().getDependencies(), dependencyPluginDescriptor) ? ParentFirstLookupStrategy.PARENT_FIRST : ChildOnlyLookupStrategy.CHILD_ONLY;
        return lookupStrategy;
    }

    private boolean isDependencyPlugin(Set<BundleDependency> pluginDependencies, ArtifactPluginDescriptor dependencyPluginDescriptor) {
        for (BundleDependency pluginDependency : pluginDependencies) {
            if (!pluginDependency.getDescriptor().getArtifactId().equals(dependencyPluginDescriptor.getBundleDescriptor().getArtifactId()) || !pluginDependency.getDescriptor().getGroupId().equals(dependencyPluginDescriptor.getBundleDescriptor().getGroupId()) || !"mule-plugin".equals(pluginDependency.getDescriptor().getClassifier().get())) continue;
            return true;
        }
        return false;
    }
}

