/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.deployment.model.internal.policy;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.internal.AbstractArtifactClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.RegionPluginClassLoadersFactory;
import org.mule.runtime.module.artifact.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.DeployableArtifactClassLoaderFactory;
import org.mule.runtime.module.artifact.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.classloader.RegionClassLoader;
import org.mule.runtime.module.artifact.descriptor.ArtifactDescriptor;

public class PolicyTemplateClassLoaderBuilder
extends AbstractArtifactClassLoaderBuilder<PolicyTemplateClassLoaderBuilder> {
    private final DeployableArtifactClassLoaderFactory artifactClassLoaderFactory;
    private ArtifactClassLoader parentClassLoader;

    public PolicyTemplateClassLoaderBuilder(DeployableArtifactClassLoaderFactory artifactClassLoaderFactory, RegionPluginClassLoadersFactory pluginClassLoadersFactory) {
        super(pluginClassLoadersFactory);
        this.artifactClassLoaderFactory = artifactClassLoaderFactory;
    }

    @Override
    protected ArtifactClassLoader createArtifactClassLoader(String artifactId, RegionClassLoader regionClassLoader) {
        return this.artifactClassLoaderFactory.create(artifactId, regionClassLoader, this.artifactDescriptor, this.artifactPluginClassLoaders);
    }

    @Override
    protected ArtifactClassLoader getParentClassLoader() {
        return this.parentClassLoader;
    }

    @Override
    public MuleDeployableArtifactClassLoader build() throws IOException {
        return (MuleDeployableArtifactClassLoader)super.build();
    }

    public PolicyTemplateClassLoaderBuilder setParentClassLoader(ArtifactClassLoader parentClassLoader) {
        this.parentClassLoader = parentClassLoader;
        return this;
    }

    @Override
    protected String getArtifactId(ArtifactDescriptor artifactDescriptor) {
        return this.getPolicyId(artifactDescriptor.getName());
    }

    public String getPolicyId(String policyName) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)policyName), "policyName cannot be empty");
        return this.parentClassLoader.getArtifactId() + "/policy/" + policyName;
    }
}

