/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.runtime.api.meta.DescribedObject;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.extension.api.util.HierarchyClassMap;

public abstract class AbstractImmutableModel
implements DescribedObject,
EnrichableModel {
    protected String description;
    protected final HierarchyClassMap<ModelProperty> modelProperties = new HierarchyClassMap();

    protected static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    protected AbstractImmutableModel(String description, Set<ModelProperty> modelProperties) {
        this.description = description != null ? description : "";
        this.loadProperties(modelProperties);
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        AbstractImmutableModel.checkArgument(propertyType != null, "Cannot get model properties of a null type");
        return Optional.ofNullable(this.modelProperties.get(propertyType));
    }

    @Override
    public Set<ModelProperty> getModelProperties() {
        return Collections.unmodifiableSet(new LinkedHashSet<ModelProperty>(this.modelProperties.values()));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    protected <T> Set<T> copy(Set<T> values) {
        return values != null ? ImmutableSet.copyOf(values) : ImmutableSet.of();
    }

    protected <T> List<T> copy(List<T> values) {
        return values != null ? ImmutableList.copyOf(values) : ImmutableList.of();
    }

    private void loadProperties(Collection<ModelProperty> properties) {
        if (properties != null) {
            properties.forEach(property -> this.modelProperties.put(property.getClass(), (ModelProperty)property));
        }
    }
}

